<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ReviewerProposal extends Model
{
    protected $table = 'reviewer_proposal';
    protected $primaryKey = 'reviewer_proposal_id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'reviewer_proposal_id', 'proposal_id', 'reviewer_id', 'status_administrasi', 'komentar', 'urut', 'created_user', 'updated_user', 'revisi_nilai'
    ];

    public function rReviewerProposalDetil()
    {
        return $this->hasMany(\App\Models\ReviewerProposalDetil::class, 'reviewer_proposal_id', 'reviewer_proposal_id');
    }

    public function reviewer()
    {
        return $this->belongsTo(Reviewer::class, 'reviewer_id', 'reviewer_id');
    }
}
