@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Mahasiswa</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
            <div class="col-md-4">

            </div>
        </div>

    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('dosen.monev-index', ['id' => $idmonev]) }}">
                        <div class="row">
                            <div class="col-md-8"></div>
                            <div class="col-md-4 text-right">
                                <div class="row">
                                    <label class="col-sm-3 col-form-label"></label>
                                    <label class="col-sm-3 col-form-label">Tahun : </label>
                                    <div class="col-sm-6">
                                        <select class="form-select" name="year" onchange="this.form.submit()">
                                        @foreach($periode as $per)
                                            <option value="{{ $per->nama }}" {{ $year == $per->nama ? 'selected' : '' }}>{{ $per->nama }}</option>
                                        @endforeach
                                    </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    <br>
                    @if(($jadwal->tanggal_mulai <= Carbon\Carbon::now()) && ($jadwal->tanggal_selesai >= Carbon\Carbon::now()))
                    <table id="datatable" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                        <thead>
                        <tr>
                            <th>No</th>
                            <th>Kode Kelompok</th>
                            <th>Identitas Ketua</th>
                            <th>Kategori PMW</th>
                            <th>Judul Proposal</th>
                            <th>Catatan Harian (Logbook)</th>
                            <th>Laporan Kemajuan</th>
                            <th>Laporan Akhir</th>
                            <th>Aksi</th>
                        </tr>
                        </thead>
                        <tbody>
                            @foreach ($proposal as $item)
                            @php $token = Str::random(30); @endphp
                            <tr id="row-{{ $token }}">
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $item->rProposal->rKelompok->kode }}</td>
                                <td>{{ $item->rProposal->rKelompok->rBiodata->name }} <br> {{ $item->rProposal->rKelompok->rBiodata->noidentitas }} <br> {{ $item->rProposal->rKelompok->rBiodata->fakultas }} <br> {{ $item->rProposal->rKelompok->rBiodata->prodi }}</td>
                                <td>{{ $item->rProposal->rJenis->nama }}</td>
                                <td>{{ $item->rProposal->judul }}</td>
                                <td>
                                    @if(is_null($item->logbook_file))
                                        <span class="badge bg-danger">Belum Upload</span>
                                    @else
                                        <a href="https://statik.unesa.ac.id/simpmw/monev/III/logbook/{{ $item->logbook_file }}" target="_blank" title="Logbook" class="btn btn-info btn-sm waves-effect waves-light"> <i class="fas fa-search"></i> Lihat</a>
                                    @endif
                                </td>
                                <td>
                                    @if(is_null($item->kemajuan_file))
                                        <span class="badge bg-danger">Belum Upload</span>
                                    @else
                                        <a href="https://statik.unesa.ac.id/simpmw/monev/III/kemajuan/{{ $item->kemajuan_file }}" target="_blank" title="Laporan Kemajuan" class="btn btn-info btn-sm waves-effect waves-light"> <i class="fas fa-search"></i> Lihat</a>
                                    @endif
                                </td>
                                <td>
                                    @if(is_null($item->akhir_file))
                                        <span class="badge bg-danger">Belum Upload</span>
                                        @else
                                        <a href="https://statik.unesa.ac.id/simpmw/monev/III/akhir/{{ $item->akhir_file }}" target="_blank" title="Laporan Akhir" class="btn btn-info btn-sm waves-effect waves-light"> <i class="fas fa-search"></i> Lihat</a>
                                        @endif
                                </td>
                                <td>
                                    <button data-bs-toggle="modal" data-bs-target="{{ '#lihat'.$item->proposal_id }}" class="btn btn-success btn-sm">Lihat Hasil Penilaian</button>

                                    <div id="{{ 'lihat'.$item->proposal_id }}" class="modal fade" tabindex="-1" role="dialog"
                                        aria-labelledby="lihatLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-xl">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="lihatLabel">{{ $title }}</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <p>
                                                        <div class="table-responsive">
                                                            <table class="table mb-0">
                                                                <tr>
                                                                    <th>Judul Proposal</th>
                                                                    <td colspan="2">{{ $item->rProposal->judul }}</td>
                                                                </tr>
                                                                <tr>
                                                                    <th>Kategori PMW</th>
                                                                    <td colspan="2">{{ $item->rProposal->rJenis->nama }}</td>
                                                                </tr>
                                                                <tr>
                                                                    <th>Status</th>
                                                                    <td colspan="2">
                                                                        @if(is_null($item->rProposal->status))
                                                                            <span class="badge bg-danger">Lolos Seleksi Internal</span>
                                                                        @else
                                                                            <span class="badge bg-success">Tidak Lolos Seleksi Internal</span>
                                                                        @endif
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <th>Nilai</th>
                                                                    <td>
                                                                        <h4 class="card-title mb-4">Reviewer 1 - {{ $item->rNilaiMonev->rReviewerBio1 ? $item->rNilaiMonev->rReviewerBio1->nama : '' }}</h4>
                                                                        <h5 class="text-muted mt-3">Nilai - {{ $item->rNilaiMonev->nilai_1 }}</h5>
                                                                    </td>
                                                                    <td>
                                                                        <h4 class="card-title mb-4">Reviewer 2 - {{ $item->rNilaiMonev->rReviewerBio2 ? $item->rNilaiMonev->rReviewerBio2->nama : '' }}</h4>
                                                                        <h5 class="text-primary mt-3">Nilai - {{ $item->rNilaiMonev->nilai_2 }}</h5>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <th>Komentar</th>
                                                                    <td colspan="2">
                                                                        <h4 class="card-title mb-4">Reviewer 1 - {{ $item->rNilaiMonev->rReviewerBio1 ? $item->rNilaiMonev->rReviewerBio1->nama : '' }}</h4>
                                                                        <p class="text-muted mb-3 pb-4">" {{ $item->rNilaiMonev->reviewer_komentar_1 }}"</p>

                                                                        <h4 class="card-title mb-4">Reviewer 2 - {{ $item->rNilaiMonev->rReviewerBio2 ? $item->rNilaiMonev->rReviewerBio2->nama : '' }}</h4>
                                                                        <p class="text-muted mb-3 pb-4">" {{ $item->rNilaiMonev->reviewer_komentar_2 }}"</p>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </div>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    @else
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Informasi!</strong> Monev Internal III dilaksanakan pada : <strong>Tanggal {{ Carbon\Carbon::parse($jadwal->tanggal_mulai)->isoFormat('D MMMM Y'); }}</strong> sampai dengan <strong>Tanggal {{ Carbon\Carbon::parse($jadwal->tanggal_selesai)->isoFormat('D MMMM Y'); }}.</strong>
                    </div>
                    @endif

                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->

@endsection

@section('js')
<script>

    function hapus(id, rowId){
        Swal.fire({
            title: 'Apakah anda yakin untuk menghapus Kelompok?',
            text: "Semua anggota kelompok juga akan terhapus",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'OK',
        }).then((result) => {
            if (result.isConfirmed) {
                var token = '{{ csrf_token() }}';
                var request = $.ajax({
                    url: '{{ route('mahasiswa.proposal.hapus') }}',
                    type: 'POST',
                    dataType: 'html',
                    data: {id:id, _token:token},
                    success: function(data){
                        Swal.fire({
                            title: 'Data Berhasil Di Hapus',
                            icon: 'success',
                            showConfirmButton: false,
                            timer: 1500
                        });

                        $('#'+rowId).remove();
                    },
                    error: function(xhr, status, error){
                        Swal.fire({
                            position: 'top-end',
                            icon: 'error',
                            title: xhr.responseText,
                            showConfirmButton: false,
                            timer: 3500
                        });
                    }
                });
            }
        })
    }
</script>
@endsection
