@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Mahasiswa</li>
                    <li class="breadcrumb-item">Seleksi Belmawa</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('mahasiswa.seleksi-belmawa-upload') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                    <h4 class="card-title">{!! $title !!}</h4>
                    <p class="card-title-desc"></p>
                    <div class="row mb-3">
                        <input class="form-control" type="hidden" id="proposal_id" name="proposal_id" value="{{ $proposal->proposal_id }}" >
                        <label for="kode" class="col-sm-2 col-form-label">Judul</label>
                        <label class="col-sm-10 col-form-label">{{ $proposal->judul }}</label>
                    </div>
                    <div class=" row mb-3">
                        <label class="col-sm-2 col-form-label">Kategori PMW</label>
                        <label class="col-sm-10 col-form-label">{{ $proposal->rJenis->nama }}</label>
                    </div>
                    <div class=" row mb-3">
                        <label class="col-sm-2 col-form-label">Komentar Review</label>
                        <label class="col-sm-10 col-form-label">
                            <h4 class="card-title mb-4">Reviewer 1 - {{ $proposal->rNilai->rReviewerBio1 ? $proposal->rNilai->rReviewerBio1->nama : '' }}</h4>
                            <p class="text-muted mb-3 pb-4">" {{ $proposal->rNilai->reviewer_komentar_1 }}"</p>

                            <h4 class="card-title mb-4">Reviewer 2 - {{ $proposal->rNilai->rReviewerBio2 ? $proposal->rNilai->rReviewerBio2->nama : '' }}</h4>
                            <p class="text-muted mb-3 pb-4">" {{ $proposal->rNilai->reviewer_komentar_2 }}"</p>
                        </label>
                    </div>
                    <div class="row mb-3" class="dropzone">
                        <label for="kode" class="col-sm-2 col-form-label">Upload Revisi Proposal</label>
                        <div class="col-sm-10">
                            @if ($errors->has('file')) <span class="text-danger">{{ $errors->first('file') }}</span> @endif
                            <input type="file" name="file" class="form-control" id="input-file">
                            <iframe id="view-pdf" width="80%" height="80%" src="" frameborder="0"></iframe>
                        </div>
                    </div>
                    <div class="mb-0">
                        <div>
                            <button type="submit" class="btn btn-primary waves-effect waves-light me-1"> Submit </button>
                            <button type="reset" class="btn btn-secondary waves-effect"> Cancel </button>
                        </div>
                    </div>
                </form>
                <br>
                <h6 class="text-danger">* PASTIKAN FILE PROPOSAL SUDAH BENAR SEBELUM DISUBMIT</h6>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->

@endsection

@section('js')

<script>
    $(function(){
        $('#input-file').change(function(){
            var input = this;
            var url = window.URL.createObjectURL(this.files[0]);
            $('#view-pdf').attr('src',url);
            $('#view-pdf').attr('height','500px');
        })
    })
</script>

@endsection
