@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Seleksi Belmawa</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
            <div class="col-md-4">
                <div class="float-end d-none d-md-block">
                    <button onclick="cetak()" class="btn btn-primary waves-effect waves-light"> <i class="fas fa-file-excel"></i> Unduh</button>
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->



    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    {!! csrf_field() !!}
                    <div class="row">
                        <div class="col-md-4">
                            <div class="row">
                                <label class="col-sm-3 col-form-label">Kategori PMW : </label>
                                <div class="col-sm-6">
                                    <select class="form-select select2" name="reqJenisPkm" id="reqJenisPkm">
                                        <option value="0">Semua</option>
                                        @foreach ($jenis as $res)
                                            <option value="{{ $res->jenis_id }}">{{ $res->nama }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="row">
                                <label class="col-sm-3 col-form-label">Status : </label>
                                <div class="col-sm-6">
                                    <select class="form-select select2" name="reqStatus" id="reqStatus">
                                        <option value="0">Semua</option>
                                        <option value="1">Menunggu Persetujuan</option>
                                        <option value="2">Lolos</option>
                                        <option value="3">Tidak Lolos</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="row">
                                <label class="col-sm-3 col-form-label">Tahun : </label>
                                <div class="col-sm-6">
                                    <select class="form-select select2" name="reqTahun" id="reqTahun">
                                        <option value="0">Semua</option>
                                        @foreach ($periode as $res)
                                            <option value="{{ $res->nama }}" @php if($res->nama == date('Y')) echo 'selected'; @endphp>{{ $res->nama }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <br>
                    <table id="example" class="table table-bordered dt-responsive wrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                        <thead>
                            <tr>
                                <th>id</th>
                                <th>Kode Kelompok</th>
                                <th>Kategori PMW</th>
                                <th>Judul Proposal</th>
                                <th>Dosen Pembimbing</th>
                                <th>Proposal</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>

                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
@endsection

@section('js')
<script>

    $("#reqJenisPkm, #reqStatus, #reqTahun").select2({
        placeholder: "Semua",
        allowClear: true
    });

    $(document).ready(function(){
        // DataTable
        var oTable = $('#example').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                "url" : "{{route('operator.getDaftarProposalBelmawa')}}",
                "data" : function ( data )
                {
                    data.jenis = $("#reqJenisPkm").val();
                    data.status = $("#reqStatus").val();
                    data.tahun = $("#reqTahun").val();
                }
            },
            columns: [
                { data: 'seleksi_belmawa_id' },
                { data: 'kode_kelompok' },
                { data: 'jenis_pkm' },
                { data: 'judul' },
                { data: 'nama_dosen' },
                { data: 'upload_dokumen' },
                { data: 'aksi' },
            ],
            columnDefs: [
                {
                    "targets": [ 0 ],
                    "visible": false,
                    "searchable": false
                }
            ],
        });

        $('#reqJenisPkm, #reqStatus, #reqTahun').change(function(){
            oTable.draw();
        });
    });

    function confirmFinal(reqId, reqStatus)
    {
        if(reqStatus == '1')
        {
            var kata = "Lolos seleksi!";
            var desc = "meloloskan";
        }
        else
        {
            var kata = "Tidak Lolos seleksi!";
            var desc = "tidak meloloskan";
        }
        Swal.fire({
            title: "Apakah Anda Yakin?",
            text: "Anda akan "+desc+" data ini!",
            icon: "warning",
            showCancelButton: !0,
            confirmButtonText: "Ya, "+ kata,
            cancelButtonText: "Tidak, Kembali!",
            confirmButtonClass: "btn btn-success mt-2",
            cancelButtonClass: "btn btn-danger ms-2 mt-2",
            buttonsStyling: !1,
            allowOutsideClick: !1,
            showLoaderOnConfirm: true
            }).then((result) => {
                if (result.value){
                    $.ajax({
                        url:'{{url("/operator/seleksi-belmawa-approval/")}}/' +reqId+'/'+reqStatus,
                        type:'GET',
                        data:{
                            "_token": "{{ csrf_token() }}",
                        },
                        dataType: "JSON",
                    })
                    .done(function(response){
                        swal.fire('Updated!', response.message, response.status).then(function(){
                            // location.reload();
                        });
                    })
                    .fail(function(){
                        swal.fire('Oops...', 'Something went wrong with ajax !', 'error');
                    });
                }
                else
                {
                    swal.fire('Batal!', 'Data batal diproses.', 'error');
                }

            })
    }

    function cetak() {
        var _token = $('input[name="_token"]').val();
        var jenis = $("#reqJenisPkm").val();
        var status = $("#reqStatus").val();
        var tahun = $("#reqTahun").val();

        window.open('{{url("/operator/cetak-daftar-belmawa/")}}?jenis='+jenis+'&tahun='+tahun+'&status='+status+'&_token='+_token, '_blank');
    };

</script>
@endsection
