@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Seleksi Internal</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
            <div class="col-md-4">
                <div class="float-end d-none d-md-block">
                    <button onclick="cetak()" class="btn btn-primary waves-effect waves-light"> <i class="fas fa-file-excel"></i> Unduh</button>
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->



    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    {!! csrf_field() !!}
                    <div class="row">
                        <div class="col-md-4">
                            <div class="row">
                                <label class="col-sm-3 col-form-label">Kategori PMW : </label>
                                <div class="col-sm-6">
                                    <select class="form-select select2" name="reqJenisPkm" id="reqJenisPkm">
                                        <option value="0">Semua</option>
                                        @foreach ($jenis as $res)
                                            <option value="{{ $res->jenis_id }}">{{ $res->nama }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="row">
                                <label class="col-sm-3 col-form-label">Status : </label>
                                <div class="col-sm-6">
                                    <select class="form-select select2" name="reqStatus" id="reqStatus">
                                        <option value="0">Semua</option>
                                        <option value="1">Menunggu Persetujuan</option>
                                        <option value="2">Lolos</option>
                                        <option value="3">Tidak Lolos</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="row">
                                <label class="col-sm-3 col-form-label">Tahun : </label>
                                <div class="col-sm-6">
                                    <select class="form-select select2" name="reqTahun" id="reqTahun">
                                        <option value="0">Semua</option>
                                        @foreach ($periode as $res)
                                            <option value="{{ $res->nama }}" @php if($res->nama == date('Y')) echo 'selected'; @endphp>{{ $res->nama }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <br>
                    <div class="table-responsive">
                        <table id="example" class="table table-bordered wrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead style="text-align: center; vertical-align: middle">
                                <tr>
                                    <th> id</th>
                                    <th width='5%'>Kode Kelompok</th>
                                    <th width='15%'>Jenis PMW</th>
                                    <th width='20%'>Judul Proposal</th>
                                    <th width='10%'>Dosen Pembimbing</th>
                                    <th width='15%'>Reviewer 1</th>
                                    <th width='15%'>Reviewer 2</th>
                                    <th width='5%'>Pendanaan</th>
                                    <th width='5%'>Nilai Akhir</th>
                                    <th width='10%'>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
@endsection

@section('js')
<script>
    $("#reqJenisPkm, #reqStatus, #reqTahun").select2({
        placeholder: "Semua",
        allowClear: true
    });
    var oTable;
    $(document).ready(function(){
        // DataTable
        oTable = $('#example').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                "url" : "{{route('operator.getDaftarProposal')}}",
                "data" : function ( data )
                {
                    data.jenis = $("#reqJenisPkm").val();
                    data.status = $("#reqStatus").val();
                    data.tahun = $("#reqTahun").val();
                }
            },
            columns: [
                { data: 'proposal_id' },
                { data: 'kode' },
                { data: 'jenis_pkm' },
                { data: 'judul' },
                { data: 'dospem' },
                { data: 'reviewer_1' },
                { data: 'reviewer_2' },
                { data: 'pendanaan' },
                { data: 'rata' },
                { data: 'aksi' },
            ],
            columnDefs: [
                {
                    "targets": [ 0 ],
                    "visible": false,
                    "searchable": false
                }
            ],
            drawCallback: function() {
                $('.select2').select2();
            }
        });

        $('#reqJenisPkm, #reqStatus, #reqTahun').change(function(){
            oTable.draw();
        });
    });

    $('#example tbody').on('change', '.reviewer', function () {
        var urut = $(this).attr('data-urut');
        var isi = this.value;
        $.ajax({
            url:'{{url("/operator/seleksi-internal-proposal")}}',
            type:'POST',
            data:{
                "_token": "{{ csrf_token() }}",
                "urut": urut,
                "data": isi,
            },
            dataType: "JSON",
        })
        .done(function(response){

            if(response.status == 'info')
            {
                Swal.fire({
                title: "Apakah Anda Yakin?",
                text: response.message,
                icon: "warning",
                showCancelButton: !0,
                confirmButtonText: "Ya, Ubah Reviewer!",
                cancelButtonText: "Tidak, Kembali!",
                confirmButtonClass: "btn btn-success mt-2",
                cancelButtonClass: "btn btn-danger ms-2 mt-2",
                buttonsStyling: !1,
                allowOutsideClick: !1,
                showLoaderOnConfirm: true
                }).then((result) => {
                    if (result.value){
                        $.ajax({
                            url:'{{url("/operator/seleksi-internal-proposal/")}}',
                            type:'POST',
                            data:{
                                "_token": "{{ csrf_token() }}",
                                "reqId" : response.id,
                                "urut": urut,
                                "data": isi,
                            },
                            dataType: "JSON",
                        })
                        .done(function(response){
                            swal.fire(response.info, response.message, response.status).then(function(){
                                // location.reload();
                            });
                        })
                        .fail(function(){
                            swal.fire('Oops...', 'Something went wrong with ajax !', 'error');
                        });
                    }
                    else
                    {
                        swal.fire('Batal!', 'Data batal diubah.', 'error');
                    }

                })
            }
            else
            {
                swal.fire(response.status, response.message, response.status).then(function(){
                    // oTable.ajax.reload();
                    // location.reload();
                });
            }
        })
        .fail(function(){
            swal.fire('Oops...', 'Something went wrong with ajax !', 'error');
        });
    });

    $('#example tbody').on('change', '.jenis', function () {
        var isi = this.value;
        Swal.fire({
            title: "Apakah Anda Yakin?",
            text: "Anda akan mengubah Kategori PMW ini?!",
            icon: "warning",
            showCancelButton: !0,
            confirmButtonText: "Ya, Ubah Kategori",
            cancelButtonText: "Tidak, Kembali!",
            confirmButtonClass: "btn btn-success mt-2",
            cancelButtonClass: "btn btn-danger ms-2 mt-2",
            buttonsStyling: !1,
            allowOutsideClick: !1,
            showLoaderOnConfirm: true
            }).then((result) => {
                if (result.value){
                    $.ajax({
                        url:'{{url("/operator/seleksi-internal-proposal-jenis")}}',
                        type:'POST',
                        data:{
                            "_token": "{{ csrf_token() }}",
                            "data": isi,
                        },
                        dataType: "JSON",
                    })
                    .done(function(response){
                        swal.fire('Updated!', response.message, response.status);
                    })
                    .fail(function(){
                        swal.fire('Oops...', 'Something went wrong with ajax !', 'error');
                    });
                }
                else
                {
                    swal.fire('Batal!', 'Data batal diproses.', 'error');
                }

            })
    });

    function confirmFinal(reqId, reqStatus) {
    if (reqStatus == '1') {
        var kata = "Lolos seleksi!";
        var desc = "meloloskan";

        var dataModal = {
            title: "Apakah Anda Yakin?",
            text: "Anda akan " + desc + " data ini!\nBerikan nominal dana yang disetujui",
            input: 'text',
            icon: "warning",
            showCancelButton: !0,
            confirmButtonText: "Ya, " + kata,
            cancelButtonText: "Tidak, Kembali!",
            confirmButtonClass: "btn btn-success mt-2",
            cancelButtonClass: "btn btn-danger ms-2 mt-2",
            buttonsStyling: !1,
            allowOutsideClick: !1,
            showLoaderOnConfirm: true,
            preConfirm: (value) => {
                if (!value) {
                    Swal.showValidationMessage('Jumlah nominal dana yang disetujui harus diisi');
                }
                return value;
            }
        };
    } else {
        var kata = "Tidak Lolos seleksi!";
        var desc = "tidak meloloskan";

        var dataModal = {
            title: "Apakah Anda Yakin?",
            text: "Anda akan " + desc + " data ini!",
            icon: "warning",
            showCancelButton: !0,
            confirmButtonText: "Ya, " + kata,
            cancelButtonText: "Tidak, Kembali!",
            confirmButtonClass: "btn btn-success mt-2",
            cancelButtonClass: "btn btn-danger ms-2 mt-2",
            buttonsStyling: !1,
            allowOutsideClick: !1,
            showLoaderOnConfirm: true
        };

        var dataAjax = {"_token": "{{ csrf_token() }}", id: reqId, status: reqStatus, dana: 0};
    }

    Swal.fire(dataModal).then((result) => {
        if (result.value) {
            let dana = 0;

            if (reqStatus == '1') {
                dana = result.value;
            }

            $.ajax({
                url: "{{ route('operator.seleksi-internal.approval') }}",
                type: 'POST',
                data: {"_token": "{{ csrf_token() }}", id: reqId, status: reqStatus, dana: dana},
                dataType: "JSON",
            })
            .done(function(response) {
                swal.fire('Updated!', response.message, response.status).then(function() {
                    oTable.draw();
                });
            })
            .fail(function() {
                swal.fire('Oops...', 'Something went wrong with ajax !', 'error');
            });
        } else {
            if (!result.dismiss) {
                swal.fire('Batal!', 'Data batal diproses, karena belum input jumlah nominal dana yang disetujui.', 'error');
            } else {
                swal.fire('Batal!', 'Data batal diproses.', 'error');
            }
        }
    });
}

    function revisi(id)
    {
        Swal.fire({
            title: "Apakah Anda Yakin?",
            text: "Anda akan membuka penilaian pada reviewer ini!",
            icon: "warning",
            showCancelButton: !0,
            confirmButtonText: "Ya",
            cancelButtonText: "Tidak",
            confirmButtonClass: "btn btn-success mt-2",
            cancelButtonClass: "btn btn-danger ms-2 mt-2",
            buttonsStyling: !1,
            allowOutsideClick: !1,
            showLoaderOnConfirm: true
            }).then((result) => {
                if (result.value){
                    $.ajax({
                        url:"{{ route('operator.seleksi-internal.buka-penilaian') }}",
                        type:'POST',
                        data:{
                            "_token": "{{ csrf_token() }}", id:id,
                        },
                        dataType: "JSON",
                    })
                    .done(function(response){
                        swal.fire('Updated!', response.message, response.status).then(function(){
                            oTable.draw();
                        });
                    })
                    .fail(function(){
                        swal.fire('Oops...', 'Something went wrong with ajax !', 'error');
                    });
                }
                else
                {
                    swal.fire('Batal!', 'Data batal diproses.', 'error');
                }

            })
    }

    function cetak() {
        var _token = $('input[name="_token"]').val();
        var jenis = $("#reqJenisPkm").val();
        var status = $("#reqStatus").val();
        var tahun = $("#reqTahun").val();

        window.open('{{url("/operator/cetak-daftar-proposal-new/")}}?jenis='+jenis+'&tahun='+tahun+'&status='+status+'&_token='+_token, '_blank');
    };

</script>
@endsection
