@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@php
    $reqId = $data['id'];
@endphp

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">{{ $jenis_monev->nama }}</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
            <div class="col-md-4">
                <div class="float-end d-none d-md-block">
                    <button onclick="cetak()" class="btn btn-primary waves-effect waves-light"> <i class="fas fa-file-excel"></i> Unduh</button>
                    <input type="hidden" name="reqMonev" id="reqMonev" value="{{ $jenis_monev->nama }}">
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    {!! csrf_field() !!}
                    <div class="row">
                        <div class="col-md-4">
                            <div class="row">
                                <label class="col-sm-3 col-form-label">Kategori PMW : </label>
                                <div class="col-sm-6">
                                    <select class="form-select select2" name="reqJenisPkm" id="reqJenisPkm">
                                        <option value="0">Semua</option>
                                        @foreach ($jenis as $res)
                                            <option value="{{ $res->jenis_id }}">{{ $res->nama }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="row">
                                <label class="col-sm-3 col-form-label">Status : </label>
                                <div class="col-sm-6">
                                    <select class="form-select select2" name="reqStatus" id="reqStatus">
                                        <option value="0">Semua</option>
                                        <option value="1">Sudah dinilai</option>
                                        <option value="2">Belum dinilai</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="row">
                                <label class="col-sm-3 col-form-label">Tahun : </label>
                                <div class="col-sm-6">
                                    <select class="form-select select2" name="reqTahun" id="reqTahun">
                                        <option value="0">Semua</option>
                                        @foreach ($periode as $res)
                                            <option value="{{ $res->nama }}">{{ $res->nama }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <br>
                    <div class="table-responsive">
                        <table id="example" class="table table-bordered wrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead align="center" style="vertical-align: middle;">
                                <tr>
                                    <th rowspan="2">id</th>
                                    <th rowspan="2">Kode Kelompok</th>
                                    <th rowspan="2">Kategori PMW</th>
                                    <th rowspan="2">Judul Proposal</th>
                                    <th rowspan="2">Dosen Pembimbing</th>
                                    <th rowspan="2">Reviewer 1</th>
                                    <th rowspan="2">Reviewer 2</th>
                                    <th colspan="2" style="text-align: center">Nilai</th>
                                    <th rowspan="2">Nilai Akhir</th>
                                    <th rowspan="2">Aksi</th>
                                </tr>
                                <tr>
                                    <th>Reviewer 1</th>
                                    <th>Reviewer 2</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
@endsection

@section('js')
<script>
    $("#reqJenisPkm, #reqStatus, #reqTahun").select2({
        placeholder: "Semua",
        allowClear: true
    });

    $(document).ready(function(){
        // DataTable
        var oTable = $('#example').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                "url" : "{{route('operator.getMonevProposal')}}",
                "data" : function ( data )
                {
                    data.jenis_monev_id = '{{ $reqId }}';
                    data.jenis = $("#reqJenisPkm").val();
                    data.status = $("#reqStatus").val();
                    data.tahun = $("#reqTahun").val();
                }
            },
            columns: [
                { data: 'monev_internal_id' },
                { data: 'kode' },
                { data: 'jenis_pkm' },
                { data: 'judul' },
                { data: 'dospem' },
                { data: 'reviewer_1' },
                { data: 'reviewer_2' },
                { data: 'nilai_1' },
                { data: 'nilai_2' },
                { data: 'rata' },
                { data: 'aksi' },
            ],
            columnDefs: [
                {
                    "targets": [ 0, 9 ],
                    "visible": false,
                    "searchable": false
                }
            ],
            drawCallback: function() {
                $('.select2').select2();
            }
        });

        $('#reqJenisPkm, #reqStatus, #reqTahun').change(function(){
            oTable.draw();
        });
    });

    $('#example tbody').on('change', '.reviewer', function () {
        var urut = $(this).attr('data-urut');
        var isi = this.value;
        $.ajax({
            url:'{{url("/operator/monev-internal-proposal")}}',
            type:'POST',
            data:{
                "_token": "{{ csrf_token() }}",
                "urut": urut,
                "data": isi,
                "jenisMonevId" : "{{ $reqId }}",
            },
            dataType: "JSON",
        })
        .done(function(response){

            if(response.status == 'info')
            {
                Swal.fire({
                title: "Apakah Anda Yakin?",
                text: response.message,
                icon: "warning",
                showCancelButton: !0,
                confirmButtonText: "Ya, Ubah Reviewer!",
                cancelButtonText: "Tidak, Kembali!",
                confirmButtonClass: "btn btn-success mt-2",
                cancelButtonClass: "btn btn-danger ms-2 mt-2",
                buttonsStyling: !1,
                allowOutsideClick: !1,
                showLoaderOnConfirm: true
                }).then((result) => {
                    if (result.value){
                        $.ajax({
                            url:'{{url("/operator/monev-internal-proposal/")}}',
                            type:'POST',
                            data:{
                                "_token": "{{ csrf_token() }}",
                                "reqId" : response.id,
                                "urut": urut,
                                "data": isi,
                            },
                            dataType: "JSON",
                        })
                        .done(function(response){
                            swal.fire(response.info, response.message, response.status).then(function(){
                                // location.reload();
                            });
                        })
                        .fail(function(){
                            swal.fire('Oops...', 'Something went wrong with ajax !', 'error');
                        });
                    }
                    else
                    {
                        swal.fire('Batal!', 'Data batal diubah.', 'error');
                    }

                })
            }
            else
            {
                swal.fire(response.status, response.message, response.status).then(function(){
                    // oTable.ajax.reload();
                    // location.reload();
                });
            }
        })
        .fail(function(){
            swal.fire('Oops...', 'Something went wrong with ajax !', 'error');
        });
    });

    function confirmFinal(reqId, reqStatus)
    {
        if(reqStatus == '1')
        {
            var kata = "Lolos seleksi!";
            var desc = "meloloskan";
        }
        else
        {
            var kata = "Tidak Lolos seleksi!";
            var desc = "tidak meloloskan";
        }
        Swal.fire({
            title: "Apakah Anda Yakin?",
            text: "Anda akan "+desc+" data ini!",
            icon: "warning",
            showCancelButton: !0,
            confirmButtonText: "Ya, "+ kata,
            cancelButtonText: "Tidak, Kembali!",
            confirmButtonClass: "btn btn-success mt-2",
            cancelButtonClass: "btn btn-danger ms-2 mt-2",
            buttonsStyling: !1,
            allowOutsideClick: !1,
            showLoaderOnConfirm: true
            }).then((result) => {
                if (result.value){
                    $.ajax({
                        url:'{{url("/operator/monev-internal-reviewer-approval/")}}/' +reqId+'/'+reqStatus,
                        type:'GET',
                        data:{
                            "_token": "{{ csrf_token() }}",
                        },
                        dataType: "JSON",
                    })
                    .done(function(response){
                        swal.fire('Updated!', response.message, response.status).then(function(){
                            location.reload();
                        });
                    })
                    .fail(function(){
                        swal.fire('Oops...', 'Something went wrong with ajax !', 'error');
                    });
                }
                else
                {
                    swal.fire('Batal!', 'Data batal diproses.', 'error');
                }

            })
    }


    function cetak() {
        var _token = $('input[name="_token"]').val();
        var id = '{{ $reqId }}';
        var jenis = $("#reqJenisPkm").val();
        var status = $("#reqStatus").val();
        var tahun = $("#reqTahun").val();
        var monev = $("#reqMonev").val();

        window.open('{{url("/operator/cetak-daftar-monev-internal/")}}?id='+id+'&jenis='+jenis+'&tahun='+tahun+'&status='+status+'&monev='+monev+'&_token='+_token, '_blank');
    };

</script>
@endsection
