@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Setting</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
            <div class="col-md-4">
                <div class="float-end d-none d-md-block">
                    <a href="{{ URL::to('operator/jenis/create') }}" type="button" class="btn btn-primary waves-effect waves-light"> <i class="fas fa-plus-circle"></i> Tambah Data</a>
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="example" class="table table-bordered dt-responsive wrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead>
                                <tr>
                                    <th>id</th>
                                    <th>Kategori PMW</th>
                                    <th>Deskripsi</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
@endsection

@section('js')
<script>
    $(document).ready(function(){
        // SweetAlert dari session (setelah tambah/edit)
        @if(session('successMessage'))
        Swal.fire({
            icon: 'success',
            title: 'Berhasil',
            text: '{{ session('successMessage') }}',
            confirmButtonText: 'OK'
        });
        @endif
        @if(session('errorMessage'))
        Swal.fire({
            icon: 'error',
            title: 'Gagal',
            text: '{{ session('errorMessage') }}',
            confirmButtonText: 'OK'
        });
        @endif

        // DataTable
        var oTable = $('#example').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                "url" : "{{ route('operator.getJenis') }}"
            },
            columns: [
                { data: 'jenis_id' },
                { data: 'nama' },
                { data: 'keterangan' },
                { data: 'aksi' },
            ],
            columnDefs: [
            {
                "targets": [ 0 ],
                "visible": false,
                "searchable": false
            }
        ]
        });
    });

    function confirmDelete(reqId)
    {
        Swal.fire({
            title: "Apakah Anda Yakin?",
            text: "Anda akan menghapus data ini!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonText: "Ya, Hapus data!",
            cancelButtonText: "Tidak, Kembali!",
            confirmButtonClass: "btn btn-success mt-2",
            cancelButtonClass: "btn btn-danger ms-2 mt-2",
            buttonsStyling: false,
            allowOutsideClick: false
        }).then((result) => {
            if (result.isConfirmed){
                $.ajax({
                    url: '{{ url("operator/jenis") }}/' + encodeURIComponent(reqId),
                    type: 'DELETE',
                    data: {
                        "_token": "{{ csrf_token() }}",
                    },
                    dataType: "JSON",
                })
                .done(function(response){
                    Swal.fire({
                        icon: response.status === 'success' ? 'success' : 'error',
                        title: response.status === 'success' ? 'Terhapus!' : 'Gagal',
                        text: response.message || (response.status === 'success' ? 'Data berhasil dihapus.' : 'Data gagal dihapus.')
                    }).then(function(){
                        location.reload();
                    });
                })
                .fail(function(xhr){
                    var msg = 'Terjadi kesalahan. Data gagal dihapus.';
                    if (xhr.responseJSON && xhr.responseJSON.message) msg = xhr.responseJSON.message;
                    Swal.fire({
                        icon: 'error',
                        title: 'Gagal',
                        text: msg
                    }).then(function(){
                        location.reload();
                    });
                });
            } else {
                Swal.fire({
                    icon: 'info',
                    title: 'Batal',
                    text: 'Data batal dihapus.'
                });
            }
        });
    }
</script>
@endsection
