@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
            <div class="col-md-4">
                <div class="float-end d-none d-md-block">
                    <button onclick="cetak()" class="btn btn-primary waves-effect waves-light"> <i class="fas fa-file-excel"></i> Unduh</button>
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    {!! csrf_field() !!}
                    <div class="row">
                        <div class="col-md-3">
                            <div class="row">
                                <label class="col-sm-4 col-form-label">Fakultas : </label>
                                <div class="col-sm-6">
                                    <select class="form-select" name="reqFakultas" id="reqFakultas">
                                        <option value="0">Semua</option>
                                        @foreach ($fakultas as $fak)
                                            <option value="{{ $fak }}">{{ $fak }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="row">
                                <label class="col-sm-4 col-form-label">Kategori PMW : </label>
                                <div class="col-sm-6">
                                    <select class="form-select" name="reqJenisPkm" id="reqJenisPkm">
                                        <option value="0">Semua</option>
                                        @foreach ($jenis as $res)
                                            <option value="{{ $res->jenis_id }}">{{ $res->nama }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="row">
                                <label class="col-sm-3 col-form-label">Status : </label>
                                <div class="col-sm-6">
                                    <select class="form-select" name="reqStatus" id="reqStatus">
                                        <option value="0">Semua</option>
                                        <option value="1">Menunggu Persetujuan Dosen</option>
                                        <option value="2">Disetujui Dosen</option>
                                        <option value="3">Ditolak Dosen</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="row">
                                <label class="col-sm-3 col-form-label">Tahun : </label>
                                <div class="col-sm-6">
                                    <select class="form-select" name="reqTahun" id="reqTahun">
                                        <option value="0">Semua</option>
                                        @foreach ($periode as $res)
                                            <option value="{{ $res->nama }}" @php if($res->nama == date('Y')) echo 'selected'; @endphp>{{ $res->nama }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <br>
                    <div class="table-responsive">
                        <table id="example" class="table table-bordered wrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Kode Kelompok</th>
                                    <th>Identitas Ketua</th>
                                    <th>Identitas Dosen Pembimbing</th>
                                    <th>Kategori PMW</th>
                                    <th>Judul Proposal</th>
                                    <th>Status</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->

    <!-- Tambahkan di luar container -->
<div id="spinner" style="display: none; position: fixed; z-index: 9999;
    top: 50%; left: 50%; transform: translate(-50%, -50%); padding: 1rem;
    background: rgba(255, 255, 255, 0.8); border-radius: 6px;">
    <div class="spinner-border text-primary" role="status"></div>
    <span style="margin-left: 10px;">Loading...</span>
</div>

@endsection

@section('js')
<script>
    $("#reqFakultas, #reqJenisPkm, #reqStatus, #reqTahun").select2({
        placeholder: "Semua",
        allowClear: true
    });

    $(document).ready(function(){
        // DataTable
        var oTable = $('#example').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                "url" : "{{route('operator.getProposal')}}",
                "data" : function ( data )
                {
                    data.fakultas = $("#reqFakultas").val();
                    data.jenis = $("#reqJenisPkm").val();
                    data.status = $("#reqStatus").val();
                    data.tahun = $("#reqTahun").val();
                }
            },
            columns: [
                { data: 'proposal_id' },
                { data: 'kode' },
                { data: 'identitas_ketua' },
                { data: 'identitas_dospem' },
                { data: 'jenis_pkm' },
                { data: 'judul' },
                { data: 'keterangan' },
                { data: 'aksi' },
            ],
            columnDefs: [
            {
                "targets": [ 0 ],
                "visible": false,
                "searchable": false
            }
        ]
        });

        $('#reqFakultas, #reqJenisPkm, #reqStatus, #reqTahun').change(function(){
            oTable.draw();
        });

        oTable.on('processing.dt', function (e, settings, processing) {
            if (processing) {
                $('#spinner').show();
            } else {
                $('#spinner').hide();
            }
        });

        $('#example').on('click','.viewdetails',function(){
            var kelId = $(this).attr('data-id');


        if(kelId != null || kelId != ''){
                // Empty modal data
                $('#tblempinfo tbody').empty();

                $.ajax({
                    url: "{{route('operator.getDetilKelompok')}}",
                    data : {
                        "kelompok_id": kelId,
                    },
                    dataType: 'json',
                    success: function(response){
                        // Add user details
                        $('#tblempinfo tbody').html(response.html);

                        // Display Modal
                        $('#empModal').modal('show');
                    }
                });
        }
        });

        $('#example').on('click','.aksi',function(){
            var propId = $(this).attr('data-id');
            var ket = $(this).attr('data-ket');

            if(propId != null || propId != ''){
                Swal.fire({
                    title: "Apakah Anda Yakin?",
                    text: ket,
                    icon: "warning",
                    showCancelButton: !0,
                    confirmButtonText: "Ya!",
                    cancelButtonText: "Tidak, Kembali!",
                    confirmButtonClass: "btn btn-success mt-2",
                    cancelButtonClass: "btn btn-danger ms-2 mt-2",
                    buttonsStyling: !1,
                    allowOutsideClick: !1,
                    showLoaderOnConfirm: true
                }).then((result) => {
                    if (result.value){
                        $.ajax({
                            url:'{{url("/operator/proses-proposal")}}',
                            type:'POST',
                            data:{
                                "_token": "{{ csrf_token() }}",
                                "proposalId": propId
                            },
                            dataType: "JSON",
                        })
                        .done(function(response){
                            swal.fire(response.status, response.message, response.status).then(function(){
                                oTable.ajax.reload();
                            });
                        })
                        .fail(function(){
                            swal.fire('Oops...', 'Something went wrong with ajax !', 'error');
                        });
                    }
                    else
                    {
                        swal.fire('Batal!', 'Data batal diproses.', 'error');
                    }
                })
            }
        });

    });

    function cetak() {
        var _token = $('input[name="_token"]').val();
        var fakultas = $("#reqFakultas").val();
        var jenis = $("#reqJenisPkm").val();
        var status = $("#reqStatus").val();
        var tahun = $("#reqTahun").val();

        window.open('{{url("/operator/cetak-proposal/")}}?fakultas='+fakultas+'&jenis='+jenis+'&tahun='+tahun+'&status='+status+'&_token='+_token, '_blank');
    };
</script>
@endsection
