@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@php
    $reqId = $data['id'];
    $periode = $data['periode'];
@endphp

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Monev Internal</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
            <div class="col-md-4">
                <div class="float-end d-none d-md-block">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#staticBackdrop">
                        <i class="fas fa-plus-circle"></i> Tambah Reviewer
                    </button>
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    {!! csrf_field() !!}
                    <div class="row">
                        <div class="col-md-4">
                            <div class="row">
                                <label class="col-sm-3 col-form-label">Tahun : </label>
                                <div class="col-sm-6">
                                    <select class="form-select select2" name="reqTahun" id="reqTahun">
                                        <option value="0">Semua</option>
                                        @foreach ($periode as $res)
                                            <option value="{{ $res->nama }}" @php if($res->nama == date('Y')) echo 'selected'; @endphp>{{ $res->nama }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <br>
                    <div class="table-responsive">
                        <table id="example" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead>
                                <tr>
                                    <th>id</th>
                                    <th>Nama Reviewer</th>
                                    <th>NIDN</th>
                                    <th>Fakultas</th>
                                    <th>Jumlah Yang Harus direview</th>
                                    <th>Jumlah Yang Sudah direview</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->

    <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel"
    aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">Data Dosen
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body" style="min-height: 500px !important">
                    <div class="table-responsive">
                        <table id="example1" class="table table-bordered dt-responsive wrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead>
                                <tr>
                                    <th>Nama Reviewer</th>
                                    <th>NIDN</th>
                                    <th>Fakultas</th>
                                    <th>Prodi</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- /.modal -->
@endsection

@section('js')
<script>
    $(document).ready(function(){
        // DataTable
        var oTable = $('#example').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                "url" : "{{route('operator.getReviewerMonev')}}",
                "data" : function ( data )
                {
                    data.jenis_monev_id = '{{ $reqId }}';
                    data.tahun = $("#reqTahun").val();
                }
            },
            columns: [
                { data: 'reviewer_id' },
                { data: 'nama' },
                { data: 'nidn' },
                { data: 'fakultas' },
                { data: 'jumlah_harus_review' },
                { data: 'jumlah_sudah_review' },
                { data: 'aksi' },
            ],
            columnDefs: [
            {
                "targets": [ 0 ],
                "visible": false,
                "searchable": false
            }
        ]
        });

        $('#reqTahun').change(function(){
            oTable.draw();
        });

        var oTable1 = $('#example1').DataTable({
            paging: true,
            searching: true,
            ordering: true,
            info: true,
            autoWidth: true,
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{route('operator.getDosen')}}",
                dataSrc: 'data'
            },
            columns: [
                { data: 'nm_sdm' },
                { data: 'nidn' },
                { data: 'fakultas' },
                { data: 'prodi' },
                { data: 'id_sdm' },
            ],
            columnDefs: [
            {
                "targets": -1,
                "data": null,
                "render": createManageBtn,
            },
            {
                "visible": false,
                "searchable": false,
            }
        ]
        });

        function createManageBtn() {
            return '<button id="manageBtn" type="button" class="btn btn-success btn-sm">Tambah</button>';
        }

        $('#example1 tbody').on('click', 'button', function () {
            var data = oTable1.row($(this).parents('tr')).data();

            Swal.fire({
                title: "Apakah Anda Yakin?",
                text: "Anda akan menambahkan reviewer ini!",
                icon: "warning",
                showCancelButton: !0,
                confirmButtonText: "Ya, Tambah data!",
                cancelButtonText: "Tidak, Kembali!",
                confirmButtonClass: "btn btn-success mt-2",
                cancelButtonClass: "btn btn-danger ms-2 mt-2",
                buttonsStyling: !1,
                allowOutsideClick: !1,
                showLoaderOnConfirm: true
            }).then((result) => {
                if (result.value){
                    $.ajax({
                        url:'{{url("/operator/monev-internal-reviewer")}}',
                        type:'POST',
                        data:{
                            "_token": "{{ csrf_token() }}",
                            "id_sdm": data['id_sdm'],
                            "nama": data['nm_sdm'],
                            "nidn": data['nidn'],
                            "fakultas": data['fakultas'],
                            "prodi": data['prodi'],
                            "jenis_monev_id": '{{ $reqId }}',
                        },
                        dataType: "JSON",
                    })
                    .done(function(response){
                        swal.fire(response.status, response.message, response.status).then(function(){
                            oTable.ajax.reload();
                        });
                    })
                    .fail(function(){
                        swal.fire('Oops...', 'Something went wrong with ajax !', 'error');
                    });
                }
                else
                {
                    swal.fire('Batal!', 'Data batal ditambahkan.', 'error');
                }
            })
        });
    });

    function confirmDelete(reqId)
    {
        Swal.fire({
            title: "Apakah Anda Yakin?",
            text: "Anda akan menghapus data ini!",
            icon: "warning",
            showCancelButton: !0,
            confirmButtonText: "Ya, Hapus data!",
            cancelButtonText: "Tidak, Kembali!",
            confirmButtonClass: "btn btn-success mt-2",
            cancelButtonClass: "btn btn-danger ms-2 mt-2",
            buttonsStyling: !1,
            allowOutsideClick: !1,
            showLoaderOnConfirm: true
            }).then((result) => {
                if (result.value){
                    $.ajax({
                        url:'{{url("/operator/seleksi_internal_reviewer/")}}/' +reqId,
                        type:'DELETE',
                        data:{
                            "_token": "{{ csrf_token() }}",
                        },
                        dataType: "JSON",
                    })
                    .done(function(response){
                        swal.fire(response.info, response.message, response.status).then(function(){
                            location.reload();
                        });
                    })
                    .fail(function(){
                        swal.fire('Oops...', 'Something went wrong with ajax !', 'error');
                    });
                }
                else
                {
                    swal.fire('Batal!', 'Data batal dihapus.', 'error');
                }

            })
    }

</script>
@endsection
