@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection
@include('sweet::alert')

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="{{ URL::to('operator/user-external') }}">Daftar User External</a></li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    {!! Form::open(array('url' => route('operator.user-external.store'), 'method' => 'POST', 'id' => 'ff', 'class' => 'form-horizontal')) !!}
                    {!! csrf_field() !!}
                        <div class="row mb-3">
                            <label for="example-search-input" class="col-sm-2 col-form-label">Email</label>
                            <div class="col-sm-10">
                                {{ Form::text('email', old('email'), array('class' => 'form-control check', 'data-info' => 'email', 'id' => 'email', 'placeholder' => 'Masukkan Email', 'required')) }}
                                @if ($errors->has('email'))
                                    <span class="help-block">{{$errors->first('email')}}</span>
                                @endif
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label for="example-search-input" class="col-sm-2 col-form-label">Nama</label>
                            <div class="col-sm-10">
                                {{ Form::text('nama', old('nama'), array('class' => 'form-control', 'placeholder' => 'Masukkan Nama', 'required')) }}
                                @if ($errors->has('nama'))
                                    <span class="help-block">{{$errors->first('nama')}}</span>
                                @endif
                            </div>
                        </div>
                        {{-- <div class="row mb-3">
                            <label for="example-text-input" class="col-sm-2 col-form-label">NIDN</label>
                            <div class="col-sm-10">
                                {{ Form::text('nidn', old('nidn'), array('class' => 'form-control check', 'data-info' => 'nidn', 'id' => 'nidn', 'placeholder' => 'Masukkan NIDN', 'required')) }}
                                @if ($errors->has('nidn'))
                                    <span class="help-block">{{$errors->first('nidn')}}</span>
                                @endif
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label for="example-search-input" class="col-sm-2 col-form-label">Fakultas</label>
                            <div class="col-sm-10">
                                {{ Form::text('fakultas', old('fakultas'), array('class' => 'form-control', 'placeholder' => 'Masukkan Fakultas', 'required')) }}
                                @if ($errors->has('fakultas'))
                                    <span class="help-block">{{$errors->first('fakultas')}}</span>
                                @endif
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label for="example-search-input" class="col-sm-2 col-form-label">Prodi</label>
                            <div class="col-sm-10">
                                {{ Form::text('prodi', old('prodi'), array('class' => 'form-control', 'placeholder' => 'Masukkan Prodi', 'required')) }}
                                @if ($errors->has('prodi'))
                                    <span class="help-block">{{$errors->first('prodi')}}</span>
                                @endif
                            </div>
                        </div> --}}

                        <div class="mb-0">
                            <div>
                                <button type="submit" class="btn btn-primary waves-effect waves-light me-1">
                                    Submit
                                </button>
                                <button type="reset" class="btn btn-secondary waves-effect">
                                    Cancel
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
@endsection

@section('js')
<script src="{{ asset('theme/js/pages/jquery.validate.min.js') }}"></script>
<script>
$('.check').on('focusout', function() {
    var info = $(this).data('info');
    if(info == 'email')
        var url = "{{url('/operator/checkemail')}}";
    else if(info == 'nidn')
        var url = "{{url('/operator/checknidn')}}";

    var value = $(this).val();
    var _token = $('input[name="_token"]').val();
    $.ajax({
        url: url,
        method:"POST",
        data:{value:value, _token:_token},
        success: function(data) {
            if(data == '1') {
                $('#email').focus();
                $('#email').val('');
                Swal.fire({
                    icon: 'error',
                    text: "Email telah terdaftar!",
                });
                // return false;
            }
            else if(data == '2') {
                $('#nidn').focus();
                $('#nidn').val('');
                Swal.fire({
                    icon: 'error',
                    text: "NIDN telah terdaftar!",
                });
                // return false;
            }
        },
        error: function(data){
            //error
        }
    });
});

$(document).ready(function() {
    $(function() {
        // [ Initialize validation ]
        $('#ff').validate({
            ignore: '.ignore, .select2-input',
            focusInvalid: false,
            rules: {
                'email': {
                    required: true,
                    email: true
                },
                'password': {
                    required: true,
                    minlength: 6,
                    maxlength: 20
                },
            },

            // Errors //

            errorPlacement: function errorPlacement(error, element) {
                var $parent = $(element).parents('.input');

                // Do not duplicate errors
                if ($parent.find('.jquery-validation-error').length) {
                    return;
                }

                $parent.append(
                    error.addClass('jquery-validation-error small form-text invalid-feedback')
                );
            },
            highlight: function(element) {
                var $el = $(element);
                var $parent = $el.parents('.form-group');

                $el.addClass('is-invalid');

                // Select2 and Tagsinput
                if ($el.hasClass('select2-hidden-accessible') || $el.attr('data-role') === 'tagsinput') {
                    $el.parent().addClass('is-invalid');
                }
            },
            unhighlight: function(element) {
                $(element).parents('.form-group').find('.is-invalid').removeClass('is-invalid');
            }
        });
    });
});
</script>
@endsection
