@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
            <div class="col-md-4">
                <div class="float-end d-none d-md-block">
                    <a href="{{ URL::to('operator/user-external/create') }}" type="button" class="btn btn-primary waves-effect waves-light"> <i class="fas fa-plus-circle"></i> Tambah Data</a>
                </div>
            </div>
        </div>

    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datatable" class="table table-bordered dt-responsive wrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead>
                                <tr>
                                    <th>No.</th>
                                    {{-- <th>NIDN</th> --}}
                                    <th>Nama</th>
                                    <th>Akun</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($users as $item)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        {{-- <td>{{ $item->rBiodata->noidentitas }}</td> --}}
                                        <td>{{ $item->name }}</td>
                                        <td>
                                            Email : <b>{{ $item->email }}</b><br>
                                            Password : <b>{{ $item->password_decrypt }}</b>
                                        </td>
                                        <td>
                                            <a href="{{ URL::to('operator/user-external/'.Crypt::encrypt($item->id).'/edit') }}" class="btn btn-icon-sm btn-primary"><i class="fas fa-edit"></i></a>

                                            <a href="#!" class="btn btn-icon-sm btn-danger" onclick="confirmDelete('{{ Crypt::encrypt($item->id) }}')"><i class="fas fa-trash"></i></a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
@endsection

@section('js')
<script src="{{ asset('theme/js/pages/datatables.init.js') }}"></script>
<script>
    $("body").on("click", ".delete", function (e) {
                e.preventDefault();
                var id = $(this).data('id');

                Swal.fire({
                    title: "Apakah Anda Yakin?",
                    text: "Anda akan menghapus data ini!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "Yes",
                    cancelButtonText: "No"
                }).then((result) => {
                    if (result.value) {
                        Swal.close();
                        $("#"+id).submit();
                    } else if (result.dismiss === Swal.DismissReason.cancel) {
                        Swal.fire('Dibatalkan', 'Data batal dihapus', 'error');
                    }
                });
            });

    function confirmDelete(reqId)
    {
        Swal.fire({
            title: "Apakah Anda Yakin?",
            text: "Anda akan menghapus data ini!",
            icon: "warning",
            showCancelButton: !0,
            confirmButtonText: "Ya, Hapus data!",
            cancelButtonText: "Tidak, Kembali!",
            confirmButtonClass: "btn btn-success mt-2",
            cancelButtonClass: "btn btn-danger ms-2 mt-2",
            buttonsStyling: !1,
            allowOutsideClick: !1,
            showLoaderOnConfirm: true
            }).then((result) => {
                if (result.value){
                    $.ajax({
                        url:'{{url("/operator/user-external/")}}/' +reqId,
                        type:'DELETE',
                        data:{
                            "_token": "{{ csrf_token() }}",
                        },
                        dataType: "JSON",
                        success: function (data) {
                            if(data.status == '1')
                            {
                                swal.fire({ title: data.info,
                                text: "",
                                icon: "success"}).then(okay => {
                                    if (okay) {
                                        location.reload();
                                    }
                                });
                            }
                            else
                                swal.fire(data.info, "", "warning");
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            swal("Data gagal dihapus.", {
                                icon: "error",
                            });
                        }
                    });
                }
                else
                {
                    swal.fire('Batal!', 'Data batal dihapus.', 'error');
                }

            })
    }
</script>
@endsection
