@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection
@php
    $jadwal = $data['jadwal'];
@endphp

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Monev Internal</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if((($jadwal->tanggal_mulai <= Carbon\Carbon::now()) && ($jadwal->tanggal_selesai >= Carbon\Carbon::now())) || $jadwal->tanggal_mulai <= Carbon\Carbon::now())
                        <div class="table-responsive">
                            <table id="example" class="table table-bordered dt-responsive wrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                <thead align="center" style="vertical-align: middle;">
                                    <tr>
                                        <th>id</th>
                                        <th>No.</th>
                                        <th>Kode Kelompok</th>
                                        <th>Identitas Ketua</th>
                                        <th>Identitas Dosen Pembimbing</th>
                                        <th>Jenis PMW</th>
                                        <th>Judul Proposal</th>
                                        <th>Catatan Harian<br>(Logbook)</th>
                                        <th>Laporan Kemajuan</th>
                                        <th>Laporan Magang / Lainnya</th>
                                        <th>Nilai</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    @else
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Informasi!</strong> {!! $title !!} dilaksanakan pada : <strong>Tanggal {{ Carbon\Carbon::parse($jadwal->tanggal_mulai)->isoFormat('D MMMM Y HH:mm:ss'); }}</strong> sampai dengan <strong>Tanggal {{ Carbon\Carbon::parse($jadwal->tanggal_selesai)->isoFormat('D MMMM Y HH:mm:ss'); }}.</strong>
                    </div>
                    @endif
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
@endsection

@section('js')
<script>
    $(document).ready(function(){
        // DataTable
        var oTable = $('#example').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                "url" : "{{route('reviewer.getDaftarMonev')}}"
            },
            columns: [
                { data: 'monev_internal_id' },
                { data: null, render: function (data, type, row, meta) {
                return meta.row + meta.settings._iDisplayStart + 1;
                    }, className: 'text-center' },
                { data: 'kode', className: 'text-center' },
                { data: 'identitas_ketua' },
                { data: 'identitas_dospem' },
                { data: 'jenis_pkm', className: 'text-center' },
                { data: 'judul', className: 'text-center' },
                { data: 'logbook', className: 'text-center' },
                { data: 'laporan_kemajuan', className: 'text-center' },
                { data: 'laporan_luaran', className: 'text-center' },
                { data: 'aksi', className: 'text-center' },
            ],
            columnDefs: [
                {
                    "targets": [ 0 ],
                    "visible": false,
                    "searchable": false
                }
            ]
        });
    });

    function confirmFinal(reqId, reqStatus)
    {
        if(reqStatus == '1')
        {
            var kata = "Lolos seleksi!";
            var desc = "meloloskan";
        }
        else
        {
            var kata = "Tidak Lolos seleksi!";
            var desc = "tidak meloloskan";
        }

        Swal.fire({
            title: "Apakah Anda Yakin?",
            text: "Anda akan "+desc+" data ini!",
            icon: "warning",
            showCancelButton: !0,
            confirmButtonText: "Ya, "+ kata,
            cancelButtonText: "Tidak, Kembali!",
            confirmButtonClass: "btn btn-success mt-2",
            cancelButtonClass: "btn btn-danger ms-2 mt-2",
            buttonsStyling: !1,
            allowOutsideClick: !1,
            showLoaderOnConfirm: true
            }).then((result) => {
                if (result.value){
                    $.ajax({
                        url:'{{url("/reviewer/seleksi-internal-approval/")}}/' +reqId+'/'+reqStatus,
                        type:'GET',
                        data:{
                            "_token": "{{ csrf_token() }}",
                        },
                        dataType: "JSON",
                    })
                    .done(function(response){
                        swal.fire('Updated!', response.message, response.status).then(function(){
                            location.reload();
                        });
                    })
                    .fail(function(){
                        swal.fire('Oops...', 'Something went wrong with ajax !', 'error');
                    });
                }
                else
                {
                    swal.fire('Batal!', 'Data batal diproses.', 'error');
                }

            })
    }
</script>
@endsection
