@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Seleksi Internal</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end page title -->



    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    {!! csrf_field() !!}
                    <div class="row">
                        <div class="col-md-4">
                            <div class="row">
                                <label class="col-sm-3 col-form-label">Adminis : </label>
                                <div class="col-sm-6">
                                    <select class="form-select select2" name="reqAdministrasi" id="reqAdministrasi">
                                        <option value="0">Semua</option>
                                        <option value="1">Menunggu Penilaian</option>
                                        <option value="2">Lolos</option>
                                        <option value="3">Tidak Lolos</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="row">
                                <label class="col-sm-3 col-form-label">Status : </label>
                                <div class="col-sm-6">
                                    <select class="form-select select2" name="reqStatus" id="reqStatus">
                                        <option value="0">Semua</option>
                                        <option value="2">Sudah dinilai</option>
                                        <option value="3">Belum dinilai</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="row">
                                <label class="col-sm-3 col-form-label">Tahun : </label>
                                <div class="col-sm-6">
                                    <select class="form-select select2" name="reqTahun" id="reqTahun">
                                        <option value="0">Semua</option>
                                        @foreach ($periode as $res)
                                            <option value="{{ $res->nama }}" @php if($res->nama == date('Y')) echo 'selected'; @endphp>{{ $res->nama }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <br>
                    <div class="table-responsive">
                        <table id="example" class="table table-bordered dt-responsive wrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead align="center" valign="middle">
                                <tr>
                                    <th>id</th>
                                    <th>Kode Kelompok</th>
                                    <th>Kategori PMW</th>
                                    <th>Judul Proposal</th>
                                    <th>Status</th>
                                    <th>Proposal</th>
                                    {{-- <th>Video Produk</th> --}}
                                    <th>Administrasi</th>
                                    <th>Nilai Subtansi Proposal</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
@endsection

@section('js')
<script>
    $(document).ready(function(){
        // DataTable
        var oTable = $('#example').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                "url" : "{{route('reviewer.getDaftarSeleksi')}}",
                "data" : function ( data )
                {
                    data.administrasi = $("#reqAdministrasi").val();
                    data.status = $("#reqStatus").val();
                    data.tahun = $("#reqTahun").val();
                }
            },
            columns: [
                { data: 'proposal_id' },
                { data: 'kode' },
                { data: 'jenis_pkm' },
                { data: 'judul' },
                { data: 'status' },
                { data: 'proposal' },
                // { data: 'video' },
                { data: 'administrasi' },
                { data: 'aksi' },
            ],
            columnDefs: [
                {
                    "targets": [ 0 ],
                    "visible": false,
                    "searchable": false
                }
            ],
        });

        $('#reqAdministrasi, #reqStatus, #reqTahun').change(function(){
            oTable.draw();
        });
    });

    // $('#example tbody').on('click', '.cek', function () {
    //     // var id = $(this).attr("id").match(/\d+/)[0];
    //     // var data = $('#example').DataTable().row( id ).data();
    //     // console.log(data[0]);
    // });

    function confirmFinal(reqId, reqStatus, rowId)
    {
        if(reqStatus == '1')
        {
            var kata = "Lolos seleksi!";
            var desc = "meloloskan";
        }
        else
        {
            var kata = "Tidak Lolos seleksi!";
            var desc = "tidak meloloskan";
        }

        Swal.fire({
            title: "Apakah Anda Yakin?",
            text: "Anda akan "+desc+" data ini!",
            icon: "warning",
            showCancelButton: !0,
            confirmButtonText: "Ya, "+ kata,
            cancelButtonText: "Tidak, Kembali!",
            confirmButtonClass: "btn btn-success mt-2",
            cancelButtonClass: "btn btn-danger ms-2 mt-2",
            buttonsStyling: !1,
            allowOutsideClick: !1,
            showLoaderOnConfirm: true
            }).then((result) => {
                if (result.value){
                    $.ajax({
                        url:'{{url("/reviewer/seleksi-internal-approval/")}}/' +reqId+'/'+reqStatus,
                        type:'GET',
                        data:{
                            "_token": "{{ csrf_token() }}",
                        },
                        dataType: "JSON",
                    })
                    .done(function(response){
                        swal.fire('Updated!', response.message, response.status).then(function(){
                            if(reqStatus == '1')
                            {
                                $("#row_"+rowId+" td:nth-last-child(2)").empty()
                                var s= $('<span class="badge bg-success">Lolos</span>');
                                $("#row_"+rowId+" td:nth-last-child(2)").append(s);

                                $("#row_"+rowId+" td:last-child").empty();
                                var t= $('<a href="{{ URL::to("reviewer/seleksi-internal/") }}/'+reqId+'/edit" class="btn btn-icon-sm btn-warning btn-sm">Beri nilai<i class="fas fa-arrow-alt-circle-right"></i></a>');
                                $("#row_"+rowId+" td:last-child").append(t);
                            }
                            else
                            {
                                $("#row_"+rowId+" td:nth-last-child(4)").empty()
                                var r= $('<span class="badge bg-success">Sudah dinilai</span>');
                                $("#row_"+rowId+" td:nth-last-child(4)").append(r);

                                $("#row_"+rowId+" td:nth-last-child(2)").empty()
                                var s= $('<span class="badge bg-danger">Tidak Lolos</span>');
                                $("#row_"+rowId+" td:nth-last-child(2)").append(s);

                                $("#row_"+rowId+" td:last-child").empty();
                                var t= $('<h4>0</h4>');
                                $("#row_"+rowId+" td:last-child").append(t);
                            }
                            // location.reload();
                        });
                    })
                    .fail(function(){
                        swal.fire('Oops...', 'Something went wrong with ajax !', 'error');
                    });
                }
                else
                {
                    swal.fire('Batal!', 'Data batal diproses.', 'error');
                }

            })
    }
</script>
@endsection
