<?php

namespace App\Exports;

use App\Models\DaftarProposalBelmawa;
use App\Models\DaftarProposalMonev;
use Illuminate\Support\Facades\DB;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class DaftarProposalMonevExport implements FromView,ShouldAutoSize
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function __construct($jenis,$status,$tahun,$monev)
    {
        $this->jenis = $jenis;
        $this->status = $status;
        $this->tahun = $tahun;
        $this->monev = $monev;
    }

    public function view(): View
    {
        $statement = " STATUS_HAPUS = '0'";

        if($this->jenis != "0")
        {
            $statement .= " AND jenis_id = '".$this->jenis."'";
        }

        if($this->status != "0")
        {
            // dikurang 1 karena di view mulai dari 0 sedangkan 0 itu menunggu persetujuan
            $status = $this->status - 1;
            $statement .= " AND STATUS_FINAL = '".$status."'";
        }

        if($this->tahun != "0")
        {
            $statement .= " AND PERIODE = '".$this->tahun."'";
        }

        if(isset($this->monev))
        {
            $statement.= " AND jenis_monev_desc = '".$this->monev."'";
        }

        $data = DaftarProposalMonev::with('rKelompokDetil')
            ->whereRaw($statement)
            ->get();

            // $result = [];

            // $no = 0;
    
            // foreach ($data as $key => $value) {
            //     // $dospem = "(".str_replace("###",") ",$value->identitas_dospem);
            //     $data_dospem = explode('###', $value->identitas_dospem);
            //     $data_ketua = explode('###', $value->identitas_ketua);
            //     $dospem = "(".$data_dospem[0].") ".$data_dospem[1];
            //     $url = "https://statik.unesa.ac.id/simpmw/proposal/".$value->periode."/".$value->upload_dokumen;
    
            //     // $urut = 1;
            //     // foreach ($value->rKelompokDetil as $keys => $detil) {
    
            //     //     if($detil->status_ketua == '1')
            //     //     {
            //     //         $keanggotaan = "Ketua";
            //     //     }
            //     //     else
            //     //     {
            //     //         $keanggotaan = "Anggota ".$urut;
            //     //         $urut++;
            //     //     }
            //     $urut = 1;
            //     $det = array();
            //     $no = 0;
            //     foreach ($value->rKelompokDetil as $keys => $detil) {
    
            //         if($detil->status_ketua == '1')
            //         {
            //             $keanggotaan = "Ketua";
            //         }
            //         else
            //         {
            //             $keanggotaan = "Anggota ".$urut;
            //             $urut++;
            //         }
    
            //         $det[$no]['fak'] = $detil->fakultas;
            //         $det[$no]['nama'] = $detil->nama;
            //         $det[$no]['nim']= $detil->nim;
            //         $det[$no]['keanggotaan'] = $keanggotaan;
    
            //         $no++;
            //     }
    
            //         $result[$no]['rowspan'] = count($value->rKelompokDetil);
            //         $result[$no]['kode'] = $value->kode;
            //         $result[$no]['jenis'] = $value->jenis_pkm;
            //         $result[$no]['detil'] = $det;
            //         $result[$no]['fak'] = $detil->fakultas;
            //         $result[$no]['nama'] = $detil->nama;
            //         $result[$no]['nim'] = $detil->nim;
            //         $result[$no]['keanggotaan'] = $keanggotaan;
            //         $result[$no]['judul'] = $value->judul;
            //         $result[$no]['dospem'] = $dospem;
            //         $result[$no]['link'] = $url;
            //         $result[$no]['status'] = $value->status_desc;
            //         $result[$no]['rata'] = $value->rata;
            //         $result[$no]['email_dospem'] = end($data_dospem);
            //         $result[$no]['email_ketua'] = end($data_ketua);
    
            //         $no++;
            //     }

        $result = []; // Untuk data hasil akhir
        $urut = 1;    // Untuk nomor anggota (reset setiap proposal)
        $index = 0;   // Indeks untuk $result

        foreach ($data as $key => $value) {
            $data_dospem = explode('###', $value->identitas_dospem);
            $data_ketua = explode('###', $value->identitas_ketua);
            $dospem = "(".$data_dospem[0].") ".$data_dospem[1];
            $url = $value->upload_dokumen ? "https://statik.unesa.ac.id/simpmw/proposal/".$value->periode."/".$value->upload_dokumen : '';
            $kemajuan = $value->kemajuan_file ?? '';
            $akhir = $value->akhir_file ?? '';

            $laporan = $this->monev == 'Monev Internal I'
                ? "https://statik.unesa.ac.id/simpmw/monev/I/kemajuan/".$kemajuan
                : "https://statik.unesa.ac.id/simpmw/monev/II/akhir/".$akhir;

            $video = $this->monev == 'Monev Internal II' ? ($value->produk_url ?? '') : ($value->url ?? '');

            $laporan_lain = 'https://simpmw.unesa.ac.id/reviewer/luaran/' . encrypt($value->proposal_id);
            $laporan_anggaran = 'https://simpmw.unesa.ac.id/operator/monev-internal/laporan-anggaran/' . encrypt($value->monev_internal_id);

            $det = []; // Untuk detail anggota setiap proposal
            $urut = 1; // Reset nomor anggota untuk setiap proposal

            foreach ($value->rKelompokDetil as $detil) {
                $keanggotaan = $detil->status_ketua == '1' ? "Ketua" : "Anggota ".$urut;
                if ($detil->status_ketua != '1') {
                    $urut++;
                }

                $det[] = [
                    'fak' => $detil->fakultas,
                    'nama' => $detil->nama,
                    'nim' => $detil->nim,
                    'keanggotaan' => $keanggotaan,
                ];
            }

            $result[$index] = [
                'rowspan' => count($value->rKelompokDetil),
                'kode' => $value->kode,
                'jenis' => $value->jenis_pkm,
                'detil' => $det,
                'judul' => $value->judul,
                'dospem' => $dospem,
                'link' => $url,
                'laporan' => $laporan,
                'video' => $video,
                'status' => $value->status_desc,
                'rata' => $value->rata,
                'email_dospem' => end($data_dospem),
                'email_ketua' => end($data_ketua),
                'kemajuan' => $kemajuan,
                'laporan_lain' => $laporan_lain,
                'akhir' => $akhir,
                'laporan_anggaran' => $laporan_anggaran,                
            ];

            $index++; // Tambahkan indeks setelah setiap proposal
        }
        $datas['list_proposal'] = $result;
        $datas['jenis_monev'] = 'Seleksi ' . $this->monev;

        return view('backend.operator.daftar_proposal.excel_new', $datas);
    }
}
