<?php

namespace App\Http\Controllers\Dosen;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Crypt;
use Alert;
use Auth;
use App\Models\Auth\Biodata;

class BiodataController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $title   = 'Biodata Dosen';
        $biodata = Biodata::query()->find(Auth::user()->id);

        $data = [
            'biodata' => $biodata,
            'title'   => $title,
        ];

        return view('backend.dosen.biodata.index', $data);
    }

    public function update($nidn)
    {

        $nidn = Crypt::decrypt($nidn);
        $biodata = $this->biodataRepo->find(null, null, null, $nidn);
        $isdm = $this->isdmRepo->nidn($nidn);

        $data = [
            'biodata' => $biodata,
            'isdm' => $isdm,
        ];

        return view('dosen.syncIsdm.index', $data);
    }

    public function sync(Request $request)
    {
        $nidn = Crypt::decrypt($request->input('nidn'));
        $biodata = $this->biodataRepo->find(null, null, null, $nidn);
        $isdm = $this->isdmRepo->nidn($nidn);

        $this->biodataRepo->sync($isdm, $biodata);

        Alert::success('Biodata disesuaikan dengan ISDM');

        return redirect()->route('dosen.biodatasync.index', ['nidn' => Crypt::encrypt($nidn)]);
    }
}
