<?php

namespace App\Http\Controllers\Dosen;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Controllers\GetDataApiController;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

use App\Models\Proposal;
use App\Models\Kelompok;
use App\Models\Periode;
use App\Models\Jenis;

use Session;
use Alert;
use App\Models\ProposalUrl;
use Auth;

class ProposalController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        $title    = 'Daftar Proposal';
        $bio      = auth()->user()->rBiodata;
        $periode  = Periode::query()->get();
        $year     = !is_null($request->year) ? $request->year : now()->year;

        // $proposal = Proposal::with(['rKelompok', 'rJenis', 'rDaftarPro'])
        //             ->whereHas('rKelompok', function ($query) use($bio){
        //                 $query->where('nidn_dosen', $bio->noidentitas)
        //                 ->orWhereRaw('LOWER(nama_dosen) = ?', [strtolower($bio->name)]);
        //             })
        //             ->whereYear('created_at', $year)
        //             ->orderBy('kelompok_id')
        //             ->get();

        $proposal = Proposal::with(['rKelompok', 'rJenis', 'rDaftarPro'])
                    ->whereHas('rKelompok', function ($query) use($bio) {
                        $query->where(function ($q) use ($bio) {
                            $q->where('nidn_dosen', $bio->noidentitas)
                            ->orWhereRaw('LOWER(nama_dosen) = ?', [strtolower($bio->name)]);
                        });
                    })
                    ->whereYear('created_at', $year)
                    ->orderBy('kelompok_id')
                    ->get();

        $data = [
            'proposal'  => $proposal,
            'title'     => $title,
            'periode'   => $periode,
            'year'      => $year,
        ];

        return view('backend.dosen.proposal.index', $data);
    }

    public function setuju(Request $request)
    {
        $proId = $request->except('_token');

        $proposal = Proposal::query()->find(decrypt($proId['id']));

        $proposal->status = 1;
        $proposal->date_approval = now();
        $proposal->save();

        Alert::success('Berhasil disimpan');

        return redirect()->route('dosen.proposal.index');
    }

    public function lihat(Request $request)
    {
        $item['proposal'] = Proposal::where('proposal_id', $request->proposal_id)->first();
        $item['url'] = ProposalUrl::where('proposal_id', $request->proposal_id)->get();

        $data = '';
        $no = 1;

        $link = '';
        foreach ($item['url'] as $surel) {
            $link .= $surel->url;
        }
        // $link = 'https://www.tiktok.com/@ringtone_29/video/7347691711562353926?is_from_webapp=1&sender_device=pc';

        // dd($link);

            if($item['proposal']->upload_dokumen){
                $dokumen = '<a href="https://statik.unesa.ac.id/simpmw/proposal/'. $item['proposal']->rPeriode->nama .'/'. $item['proposal']->upload_dokumen.'"  target="_blank" class="btn btn-success btn-sm"> <i class="far fa-eye"></i> Lihat Proposal</a>';
                $url = '<a id="lihat" class="btn btn-success btn-sm" data-video="'. $link .'"><i class="far fa-eye"></i> Lihat Video</a>';
                }
            else{
                $dokumen = '<div class="alert alert-danger alert-dismissible fade show mb-0" role="alert">
                                <strong>Informasi!</strong><br/> File tidak ditemukan.
                            </div>';
                $url = '<div class="alert alert-danger alert-dismissible fade show mb-0" role="alert">
                            <strong>Informasi!</strong><br/> File tidak ditemukan.
                        </div>';
                }

            if(is_null($item['proposal']->status) OR $item['proposal']->status == '0'){
                $status = '<span class="badge bg-danger">Menunggu Persetujuan Dosen</span>';
            }else{
                $status = '<span class="badge bg-success">Sudah Disetujui Dosen</span>';
            }

            $data .= "
                        <tr>
                                <td>Judul Proposal</td>
                                <td>".$item['proposal']->judul."</td>
                            </tr>
                            <tr>
                                <td>Kategori PMW</td>
                                <td>".$item['proposal']->rJenis->nama."</td>
                            </tr>
                            <tr>
                                <td>Status</td>
                                <td>".$status."</td>
                            </tr>
                            <tr>
                                <td>Proposal</td>
                                <td>".$dokumen."</td>
                            </tr>
                            <tr>
                                <td>Video Produk</td>
                                <td>".$url."</td>
                        </tr>

                    ";

        $response['html'] = $data;
        echo json_encode($response);
    }

    public function approve($id)
    {
        $proposal = Proposal::query()->find(decrypt($id));

	    return response()->json([
	      'data' => $proposal
	    ]);
    }

    public function tolak(Request $request)
    {
        $proId = $request->except('_token');

        $proposal = Proposal::query()->find($proId['proposal_id']);

        $proposal->status = 2;
        $proposal->alasan_revisi = $proId['alasan_revisi'];
        $proposal->save();

        Alert::success('Berhasil ditolak');

        return redirect()->route('dosen.proposal.index');
    }
}
