<?php

namespace App\Http\Controllers\Mahasiswa;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Crypt;
use Alert;
use Auth;
use App\Models\Auth\Biodata;

class BiodataController extends Controller
{

    public function index()
    {
        $title   = 'Biodata Mahasiswa';
        $biodata = Biodata::query()->find(Auth::user()->id);

        $data = [
            'biodata' => $biodata,
            'title'   => $title,
        ];

        return view('backend.mahasiswa.biodata.index', $data);
    }

    public function update($nidn)
    {

        $nidn = Crypt::decrypt($nidn);
        $biodata = $this->biodataRepo->find(null, null, null, $nidn);
        $isdm = $this->isdmRepo->nidn($nidn);

        $data = [
            'biodata' => $biodata,
            'isdm' => $isdm,
        ];

        return view('mahasiswa.syncIsdm.index', $data);
    }

    public function sync(Request $request)
    {
        $nidn = Crypt::decrypt($request->input('nidn'));
        $biodata = $this->biodataRepo->find(null, null, null, $nidn);
        $isdm = $this->isdmRepo->nidn($nidn);

        $this->biodataRepo->sync($isdm, $biodata);

        Alert::success('Biodata disesuaikan dengan ISDM');

        return redirect()->route('mahasiswa.biodatasync.index', ['nidn' => Crypt::encrypt($nidn)]);
    }
}
