<?php

namespace App\Http\Controllers\Operator;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

use App\Models\Pengumuman;

use Session;
use Alert;
use Auth;


class PengumumanController extends Controller
{

    public function index()
    {
        //
        $title = 'Pengumuman';

        $pengumuman = Pengumuman::query()->first();

        $data = [
            'pengumuman'  => $pengumuman,
            'title'     => $title,
        ];

        return view('backend.operator.pengumuman.index', $data);
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        //
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        //
    }

    public function update(Request $request, $id)
    {
        //
        $pengumuman   = $request->except('_token');

        $this->validate($request,
        [
            'file' => 'mimes:pdf|max:5000'
        ], [
            'file.mimes' => 'File harus pdf',
            'file.max' => 'File tidak boleh lebih dari 5 mb',
        ]);

        $pro = Pengumuman::find($id);

        if(!isset($pengumuman['file'])){
            $file_nama = $pro->file;
        } else {
            // Storage::disk('static')->delete('simpkm/pengumuman/'.$pro->rPeriode->nama.'/'.$pro->upload_dokumen);

            $file_nama = $pro->id.'.'.$pengumuman['file']->getClientOriginalExtension();
            Storage::disk('static')->put('simpkm/pengumuman/'.$file_nama, file_get_contents($pengumuman['file']->getRealPath()));
        }

        $pro->pengumuman      = $pengumuman['pengumuman'];
        $pro->file            = $file_nama;

        $pro->save();

        return redirect()->route('operator.pengumuman.index')->with('success', 'Pengumuman berhasil di Edit');
    }

    public function destroy($id)
    {
        //
    }
}
