<?php

namespace App\Models;

use App\Traits\UuidTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProposalUrl extends Model
{
    use HasFactory;
    use UuidTrait;

    protected $table = 'proposal_url';
    protected $primaryKey = 'id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'id',
        'url',
        'url_name',
        'deskripsi',
        'proposal_id',
        'created_at',
        'updated_at'
    ];

    public function rProposal()
    {
        return $this->belongsTo(Proposal::class, 'proposal_id', 'proposal_id');
    }
}
