<?php

namespace App\Repositories\Auth;

use GuzzleHttp\Client as GuzzleHttpClient;

class IsdmRepository
{
    /**
     * Get data from isdm.
     *
     * @param  varchar  $nip
     * @return \Illuminate\Http\Response
     */
    public function nip($nip)
    {
        $client = new GuzzleHttpClient();
        $apiRequest = $client->request('GET', 'https://i-sdm.unesa.ac.id/biodataumum/' . $nip);
        $isdm = json_decode($apiRequest->getBody()->getContents());

        return $isdm;
    }

    /**
     * Get data from isdm.
     *
     * @param  varchar  $nidn
     * @return \Illuminate\Http\Response
     */
    public function nidn($nidn)
    {
        $client = new GuzzleHttpClient();
        $apiRequest = $client->request('GET', 'https://i-sdm.unesa.ac.id/api/biodataumum/' . $nidn);
        $isdm = json_decode($apiRequest->getBody()->getContents());

        return $isdm;
    }
}
