@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Mahasiswa</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-10">
                            <h4 class="card-title">Dosen Pembimbing</h4>
                        </div>
                    </div>
                    <br/>
                    <div class="table-responsive">
                        <table class="table table-hover table-centered table-nowrap mb-0">
                            <tbody>
                                <tr class="table-light">
                                    <td>Kode Kelompok</td>
                                    <td>NIDN Dosen</td>
                                    <td>Dosen Pembimbing</td>
                                </tr>
                                <tr>
                                    <td>{{ $kelompok->kode }}</td>
                                    <td>{{ $kelompok->nidn_dosen }}</td>
                                    <td>{{ $kelompok->nama_dosen }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <br/>
                    <div class="row">
                        <div class="col-10">
                            <h4 class="card-title">Anggota Kelompok</h4>
                        </div>
                        {{-- <div class="col-2">
                            <a href="{{ URL::to('mahasiswa/anggota/create') }}" class="btn btn-info btn-sm">Tambah Anggota</a>
                        </div> --}}
                        @if($kelompok->rAnggota->count() < 5)
                        <div class="col-2">
                            <a href="{{ URL::to('mahasiswa/anggota/create') }}" class="btn btn-info btn-sm">Tambah Anggota</a>
                        </div>
                        @endif
                    </div>
                    <br/>
                    <div class="table-responsive">
                        <table class="table table-hover table-centered table-nowrap mb-0">
                            <thead>
                            <tr class="table-light">
                                <td>No</td>
                                <td>Nama</td>
                                <td>NIM</td>
                                <td>Fakultas</td>
                                <td>Program Studi</td>
                                <td>Keterangan</td>
                                <td>#</td>
                            </tr>
                            <thead>
                            <tbody>
                                @foreach ($kelompok->rAnggota as $item)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ ucwords(strtolower($item->nama)) }}</td>
                                    <td>{{ $item->nim }}</td>
                                    <td>{{ $item->fakultas }}</td>
                                    <td>{{ $item->prodi }}</td>
                                    <td>
                                        @if($item->status_ketua == 1)
                                            Ketua
                                        @else
                                            Anggota {{ $loop->iteration-1 }}
                                        @endif
                                    </td>
                                    <td>
                                        @if($item->status_ketua != 1)
                                            {{-- <form action="{{ route('mahasiswa.anggota.destroy', $item->kelompok_detil_id) }}" method="POST" onsubmit="return confirm('Yakin ingin menghapus anggota ini?');"> --}}
                                            <form action="{{ route('mahasiswa.anggota.destroy', $item->kelompok_detil_id) }}" method="POST" class="delete-form">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" id="deleteButton"><i class="fas fa-trash-alt"></i></button>
                                            </form>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>


        {{ Form::open(['url' => route('mahasiswa.kelompok.kirim'), 'method' => 'post', 'id' => 'addKelompok']) }}
        {!! Form::hidden('kelompok_id', $kelompok->kelompok_id) !!}
        {{ Form::close() }}

        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Informasi!</strong> Anggota kelompok minimal 3 dan maksimal 5 </strong>
                    </div>
                    <div class="mb-0">
                        @if($kelompok->rAnggota->count() >= 3 && $kelompok->rAnggota->count() <= 5)
                            <button type="submit" class="btn btn-primary waves-effect waves-light me-1 btnSimpanKelompok" id="btnSimpanKelompok"> Submit </button>
                        @endif
                        <a href="{{ URL::to('mahasiswa/kelompok') }}" type="reset" class="btn btn-secondary waves-effect"> Kembali </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end row -->

@endsection

@section('js')
<script>
    $(".btnSimpanKelompok").click(function (e) {
        e.preventDefault();
        $(".btnSimpanKelompok").hide();
        $("#andou").html("<h3>Sedang proses ... </h3>");

        $("#addKelompok").submit();
    });
</script>
<script>
    // Menambahkan SweetAlert untuk konfirmasi penghapusan
    document.querySelectorAll('.delete-form').forEach((form) => {
        form.addEventListener('submit', function (e) {
            e.preventDefault();  // Mencegah form untuk submit langsung

            Swal.fire({
                title: 'Yakin ingin menghapus anggota ini?',
                text: "Data ini tidak bisa dikembalikan lagi!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal',
                reverseButtons: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#28a745'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Jika user memilih "Ya", form akan disubmit
                    form.submit();
                }
            });
        });
    });
</script>
@endsection
