<?php

namespace App\Http\Controllers\Dosen;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Periode;
use App\Models\MonevInternal;
use App\Models\JadwalKegiatan;

use Session;
use Alert;
use Auth;

class MonevController extends Controller
{
    public function monev($id, Request $request)
    {
        $bio      = auth()->user()->rBiodata;
        $nidn     = $bio->noidentitas;
        $periode  = Periode::query()->get();
        $year     = !is_null($request->year) ? $request->year : now()->year;
        $jadwal   = JadwalKegiatan::where('periode_id', $periode->where('status', 1)->first()->periode_id)
                                  ->where('nama','Monev Internal '.$id)->first();

        $title    = 'Monev Internal '.$id;
        $proposal = MonevInternal::with(['rProposal', 'rJenisMonev'])
                    ->whereHas('rProposal', function ($query) use($nidn){
                        $query->whereHas('rKelompok', function ($query) use($nidn){
                                $query->where('nidn_dosen', $nidn);
                        });
                    })
                    ->whereHas('rJenisMonev', function ($query) use($id){
                        $query->where('nama', 'Monev Internal '.$id);
                    })
                    ->whereYear('created_at', $year)
                    ->orderBy('created_at')
                    ->get();

               // dd($proposal);
        $data = [
            'proposal'  => $proposal,
            'title'     => $title,
            'jadwal'    => $jadwal,
            'periode'   => $periode,
            'idmonev'   => $id,
            'year'      => $year,
        ];

        return view('backend.dosen.monev.indexmonev'.$id, $data);
    }

}
