<?php

namespace App\Http\Controllers\Mahasiswa;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\GetDataApiController;

use App\Models\Kelompok;
use App\Models\KelompokDetail;
use App\Models\Periode;

use Session;
use Alert;


class KelompokController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        $title      = 'Kelompok Mahasiswa';
        $bio        = auth()->user()->rBiodata;
        $nim        = $bio->noidentitas;
        $getDosen   = GetDataApiController::getDosen();
        $periode    = Periode::query()->orderBy('nama', 'ASC')->get();
        $periode_aktif    = Periode::where('status', '1')->first();
        $year       = !is_null($request->year) ? $request->year : now()->year;

        $kelompok = Kelompok::with(['rAnggota'])
                    ->whereHas('rAnggota', function ($query) use($nim){
                        $query->where('nim', $nim);
                    })
                    ->whereYear('created_at', $year)
                    ->orderBy('kode')
                    ->get();

        $cekKel   = $kelompok->where('created_user', auth()->user()->id)->where('periode_id', $periode_aktif->periode_id)->whereIn('status', [0,1])->count();

        // $getMhs   = GetDataApiController::getAccount(20030244001);
        // dd($getMhs);

        $data = [
            'kelompok'  => $kelompok,
            'title'     => $title,
            'cekKel'    => $cekKel,
            'dosen'     => $getDosen['data'],
            'periode'   => $periode,
            'year'      => $year,
        ];

        return view('backend.mahasiswa.kelompok.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $title      = 'Kelompok Mahasiswa';
        $bio        = auth()->user()->rBiodata;
        $nim        = $bio->noidentitas;
        $getDosen   = GetDataApiController::getDosen();
        $periode    = Periode::query()->where('status', '1')->first();


        $data = [
            'title'     => $title,
            'dosen'     => $getDosen['data'],
            'periode'   => $periode,
        ];


        return view('backend.mahasiswa.kelompok.create', $data);
    }

    public function newkelompok($id)
    {
        //
        $kelompok_id = decrypt($id);
        Session::put('ss_kelompokid', $kelompok_id);

        $title      = 'Tambah Kelompok Mahasiswa';
        $kelompok   = Kelompok::with('rAnggota')->where('kelompok_id', $kelompok_id)->first();
        $periode    = Periode::where('status', '1')->first();
        $getDosen   = GetDataApiController::getDosen();


        $data = [
            'kelompok'  => $kelompok,
            'title'     => $title,
            'dosen'     => $getDosen['data'],
        ];

        return view('backend.mahasiswa.kelompok.createkel', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $kelompok = $request->except('_token');

        $dosen         = explode('_', decrypt($kelompok['dosen']));
        $dosen_idsdm   = $dosen[0];
        $dosen_nama    = $dosen[1];
        $dosen_nidn    = $dosen[2];

        $bio = auth()->user()->rBiodata;

        $kel = Kelompok::create([
                'periode_id'    => $kelompok['periode'],
                'id_sdm'        => $dosen_idsdm,
                'nama_dosen'    => $dosen_nama,
                'nidn_dosen'    => $dosen_nidn,
                'created_user'  => Auth::user()->id
            ]);


            KelompokDetail::create([
                    'kelompok_id'  => $kel->kelompok_id,
                    'id_reg_pd'    => $bio->user_id,
                    'nim'          => $bio->noidentitas,
                    'nama'         => $bio->name,
                    'fakultas'     => $bio->fakultas,
                    'prodi'        => $bio->prodi,
                    'status_ketua' => '1',
                    'created_user' => Auth::user()->id
                ]);

        return redirect()->intended(route('mahasiswa.kelompok.createnew', ['id' => encrypt($kel->kelompok_id)]))->with('success', 'Berhasil membuat Kelompok!');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //

    }

    public function kirim(Request $request)
    {
        //
        $kel = $request->except('_token');

        $kelompok = Kelompok::query()->find($kel['kelompok_id']);

        $kelompok->status = 1;
        $kelompok->kirim = 1;
        $kelompok->save();

        Alert::success('Berhasil disimpan');

        return redirect()->route('mahasiswa.kelompok.index');
    }

    public function hapus(Request $request)
    {
        $kel = $request->except('_token');

        $kelompok = Kelompok::query()->find(decrypt($kel['id']));

        $kelompok->rAnggota()->delete();
        $kelompok->delete();

        Alert::success('Berhasil dihapus');

        return redirect()->route('mahasiswa.kelompok.index');
    }

    // public function cetak_kelompok(Request $request)
    // {
    //     $fakultas = $request->fakultas;
    //     $prodi = $request->prodi;
    //     $lulusan = $request->lulusan;
    //     $group = $request->group;

    //     if(isset($this->rUserDetil->fakultas_id))
    //     {
    //         $fakultas = $this->rUserDetil->fakultas_id;
    //     }

    //     if(isset($this->rUserDetil->prodi_id))
    //     {
    //         $prodi = $this->rUserDetil->prodi_id;
    //     }

    //     return Excel::download(new UsersExport($fakultas, $prodi, $lulusan, $group), 'users_export.xlsx');
    // }
}
