<?php

namespace App\Http\Controllers\Operator;

use App\Http\Controllers\Controller;
use DB;

use URL;
use Auth;
use Uuid;
use Crypt;
use Carbon\Carbon;

use Illuminate\Http\Request;
use App\Models\JadwalKegiatan;

class JadwalKegiatanController extends Controller
{
    public function index()
    {
		$data_periode = DB::table('periode')->select('periode_id', 'nama', 'keterangan')->where('status', '1')->first();
        session(['periode_id' => $data_periode->periode_id]);

		$periode_id = session('periode_id');

        $data['jadwal_kegiatan'] = JadwalKegiatan::where('status_hapus', '0')->where('periode_id', $periode_id)->orderBy('urut')->get();

        return view('backend.operator.jadwal_kegiatan.index', compact('data'))->withTitle('Jadwal Kegiatan');
    }

    /* AJAX request */
    public function getData(Request $request){

    }

    public function create()
    {

    }

    public function store(Request $request)
    {
        foreach ($request->tanggal as $key => $value) {
            if(!empty($value))
            {
                $tanggal = explode(" - ", $value);
                $tanggal_mulai = $tanggal[0];
                $tanggal_selesai = $tanggal[1];

                JadwalKegiatan::where('jadwal_kegiatan_id', $key)->update(['tanggal_mulai'=>Carbon::createFromFormat('d-m-Y H:i', $tanggal_mulai)->format('Y-m-d H:i'), 'tanggal_selesai'=>Carbon::createFromFormat('d-m-Y H:i', $tanggal_selesai)->format('Y-m-d H:i')]);
            }
        }

        return redirect()->route('operator.jadwal-kegiatan.index')->with('successMessage', 'Jadwal kegiatan berhasil disimpan.');
    }

    public function edit($id)
    {

    }

    public function update(Request $request, $id)
    {

    }

    public function destroy($id)
    {

    }
}
