<?php

namespace App\Http\Controllers\Operator;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use DB;
use URL;
use Auth;
use Uuid;
use Alert;
use Crypt;

use App\Models\Jenis;
use App\Models\JenisPenilaianMonev;

class JenisPenilaianMonevController extends Controller
{
    public function index()
    {
        return view('backend.operator.jenis_penilaian_monev.index')->withTitle('Kategori PMW');
    }

    /* AJAX request */
    public function getData(Request $request){

        ## Read value
        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length"); // Rows display per page

        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');

        $columnIndex = $columnIndex_arr[0]['column']; // Column index
        $columnName = $columnName_arr[$columnIndex]['data']; // Column name
        $columnSortOrder = $order_arr[0]['dir']; // asc or desc
        $searchValue = strtoupper($search_arr['value']); // Search value

        // Total records
        $statementGlobal = " STATUS_HAPUS = '0' ";
        $totalRecords = Jenis::select('count(1) as allcount')->whereRaw($statementGlobal)->count();
        $statement = " AND (UPPER(NAMA) LIKE '%".$searchValue."%') ";

        $totalRecordswithFilter =   Jenis::select('count(1) as allcount')
                                    ->whereRaw($statementGlobal.$statement)->count();

        // Fetch records
        $records = Jenis::orderBy($columnName,$columnSortOrder)
            ->whereRaw($statementGlobal.$statement)
            ->select('jenis.*')
            ->selectRaw('ambil_jumlah_jenis_penilaian(jenis.jenis_id) jumlah_komponen')
            ->skip($start)
            ->take($rowperpage)
            ->get();

        $data_arr = array();
        foreach($records as $record){
            $jenis_id = $record->jenis_id;
            $nama = $record->nama;
            $keterangan = $record->keterangan;
            $jumlah_komponen = $record->jumlah_komponen;

            $edit  =  URL::to('operator/jenis-penilaian-monev/'.Crypt::encrypt($jenis_id).'/edit');

            $data_arr[] = array(
                "jenis_id" => $jenis_id,
                "nama" => $nama,
                "keterangan" => $keterangan,
                "jumlah_komponen" => $jumlah_komponen,
                "aksi" => '<td class="table-action">
                                <a href="'.$edit.'" class="btn btn-icon-sm btn-primary"><i class="fas fa-clipboard-list"></i></a>
                            </td>'
            );
        }

        $response = array(
            "draw" => intval($draw),
            "iTotalRecords" => $totalRecords,
            "iTotalDisplayRecords" => $totalRecordswithFilter,
            "aaData" => $data_arr
        );

        echo json_encode($response);
        exit;
    }

    public function create()
    {

    }

    public function store(Request $request)
    {

    }

    public function edit($id)
    {
        $jenis = Jenis::where('jenis_id', '=', Crypt::decrypt($id))->get();
        $jenis_penilaian_monev = JenisPenilaianMonev::where('jenis_id', '=', Crypt::decrypt($id))->get();

        $data = [
            'jenis' => $jenis,
            'jenis_penilaian_monev' => $jenis_penilaian_monev,
            'encrypted_id' => $id,
        ];

        return view('backend.operator.jenis_penilaian_monev.edit', compact('data'))->withTitle('Ubah Kategori PMW');
    }

    public function update(Request $request, $id)
    {
        $decrypted_id = Crypt::decrypt($id);

        JenisPenilaianMonev::where('jenis_id', $decrypted_id)->delete();

        for($i=0; $i<count($request->nama); $i++)
        {
            $uuid = decrypt($request->jenis_penilaian_monev_id[$i]);
            $data['jenis_penilaian_monev_id'] = $uuid;
            $data['jenis_id'] = $decrypted_id;
            $data['nama'] = $request->nama[$i];
            $data['bobot'] = 1;

            JenisPenilaianMonev::updateOrCreate([
                'jenis_penilaian_monev_id' => $uuid
            ],
            $data);
        }

        return redirect()->route('operator.jenis-penilaian-monev.index')->with('successMessage', 'Data berhasil diubah.');

    }

}
