<?php

namespace App\Http\Controllers\Operator;

use App\Http\Controllers\Controller;
use App\Models\Role;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Role as ModelsRole;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data['title'] = 'Daftar User';
        $data['users'] = User::with(['rBiodata','rolesCustom'])->whereHas('rolesCustom',function ($q){
                                $q->whereIn('name', ['dosen','reviewer','tendik']);
                            })->where('status', '1')->get();

        $data['roles'] = Role::whereIn('name', ['reviewer', 'operator'])->orderBy('name')->get();

        return view('backend.operator.user.index', $data);
    }

    public function removeRole(Request $request)
    {
        DB::table('model_has_roles')
        ->where([['model_id', decrypt($request->user_id)], ['role_id', decrypt($request->role_id)]])
        ->delete();

        return response('success', 200);
    }

    public function addRole(Request $request)
    {
        $data['role'] = Role::query()->find(decrypt($request->role_id));
        $data['user'] = User::query()->find(decrypt($request->user_id));
        $data['user']->assignRole($data['role']);

        return view('backend.operator.user.row_role', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $menu = 'artikel';
        $edit = false;

        $data = [
            'menu' => $menu,
            'edit' => $edit,
        ];

        return view('mahasiswa.inbound.biodata.index', $data);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
