<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Traits\UuidTrait;
use Illuminate\Database\Eloquent\Model;

class Proposal extends Model
{
    use HasFactory;
    use UuidTrait;

    protected $table = 'proposal';
    protected $primaryKey = 'proposal_id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'kelompok_id',
        'proposal_id',
        'jenis_id',
        'periode_id',
        'judul',
        'status',
        'upload_dokumen',
        'date_upload',
        'date_approval',
        'alasan_revisi',
        'status_hapus',
        'created_user',
        'created_at',
        'updated_user',
        'updated_at',
        'revisi_filebelmawa',
        'revisi_datebelmawa',
        'revisi_approvalbelmawa',
        'logbook_file',
        'logbook_date',
        'logbook_approval',
        'laporan_kemajuan_file',
        'laporan_kemajuan_date',
        'laporan_kemajuan_approval',
        'laporan_akhir_file',
        'laporan_akhir_date',
        'laporan_akhir_approval',
        'pendanaan',
        'usulan_dana',

    ];

    public function rKelompok()
    {
        return $this->hasOne(Kelompok::class, 'kelompok_id', 'kelompok_id')->with(['rBiodata']);
    }

    public function rJenis()
    {
        return $this->hasOne(Jenis::class, 'jenis_id', 'jenis_id');
    }

    // public function rMahasiswa()
    // {
    //     return $this->hasOne(Jenis::class, 'jenis_id', 'jenis_id');
    // }

    // public function rDosen()
    // {
    //     return $this->hasOne(Jenis::class, 'jenis_id', 'jenis_id');
    // }

    public function rPeriode()
    {
        return $this->hasOne(Periode::class, 'periode_id', 'periode_id');
    }

    public function rProposalUrl()
    {
        return $this->hasOne(ProposalUrl::class, 'proposal_id', 'proposal_id');
    }

    public function rLuaran()
    {
        return $this->hasMany(ProposalLuaran::class, 'proposal_id', 'proposal_id');
    }

    public function rMonev()
    {
        return $this->hasMany(MonevInternal::class, 'proposal_id', 'proposal_id');
    }

    public function rNilai()
    {
        return $this->hasOne(VDaftarProposal::class, 'proposal_id', 'proposal_id')->with(['rReviewerBio1', 'rReviewerBio2']);
    }

    public function rNilaiMonev()
    {
        return $this->hasOne(VDaftarMonev::class, 'proposal_id', 'proposal_id')->with(['rReviewerBio1', 'rReviewerBio2']);
    }

    public function rDaftarPro()
    {
        return $this->hasOne(DaftarProposal::class, 'proposal_id', 'proposal_id');
    }

    public function rReviewProposal()
    {
        return $this->hasOne(ReviewerProposal::class, 'proposal_id', 'proposal_id');
    }

    public function rBuktiAnggaran()
    {
        return $this->hasMany(BuktiAnggaran::class, 'proposal_id', 'proposal_id');
    }

    public function rBelmawa()
    {
        return $this->hasOne(SeleksiBelmawa::class, 'proposal_id', 'proposal_id');
    }
}

