<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Traits\UuidTrait;

use Illuminate\Database\Eloquent\Model;

class ProposalLuaran extends Model
{
    use HasFactory;
    use UuidTrait;

    protected $table = 'proposal_luaran';
    protected $primaryKey = 'id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'id',
        'proposal_id',
        'judul',
        'jenis_luaran',
        'kategori_luaran',
        'keterangan_luaran',
        'file_luaran',
        'created_user',
        'created_at',
        'updated_user',
        'updated_at',
    ];

    public function rProposal()
    {
        return $this->hasOne(Proposal::class, 'proposal_id', 'proposal_id')->with('rPeriode');
    }
}

