<?php

namespace App\Models;

use App\Models\Auth\Biodata;
use Illuminate\Database\Eloquent\Model;

class Reviewer extends Model
{
    protected $table = 'reviewer';
    protected $primaryKey = 'reviewer_id';
    public $incrementing = false;

    protected $fillable = [
        'reviewer_id', 'periode_id', 'jenis_monev_id', 'id_sdm', 'nama', 'nidn', 'fakultas', 'prodi', 'status_hapus', 'created_user', 'updated_user'
    ];

    public function biodata()
    {
        return $this->belongsTo(Biodata::class, 'id_sdm', 'noidentitas');
    }
}
