@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Mahasiswa</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
            <div class="col-md-4">
                <div class="float-end d-none d-md-block">

                </div>
            </div>
        </div>

    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('dosen.seleksi-internal') }}">
                        <div class="row">
                            <div class="col-md-8"></div>
                            <div class="col-md-4 text-right">
                                <div class="row">
                                    <label class="col-sm-3 col-form-label"></label>
                                    <label class="col-sm-3 col-form-label">Tahun : </label>
                                    <div class="col-sm-6">
                                        <select class="form-select" name="year" onchange="this.form.submit()">
                                        @foreach($periode as $per)
                                            <option value="{{ $per->nama }}" {{ $year == $per->nama ? 'selected' : '' }}>{{ $per->nama }}</option>
                                        @endforeach
                                    </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    <br>
                    <div class="table-responsive">
                        <table id="datatable" class="table table-bordered dt-responsive" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead  style="text-align: center; vertical-align: middle;">
                            <tr>
                                <th>No</th>
                                <th>Kode Kelompok</th>
                                <th>Identitas Ketua</th>
                                <th>Kategori PMW</th>
                                <th>Judul Proposal</th>
                                <th>Usulan Dana</th>
                                <th>Status</th>
                                <th>Aksi</th>
                            </tr>
                            </thead>
                            <tbody>
                                @foreach ($proposal as $item)
                                @php $token = Str::random(30); @endphp
                                <tr id="row-{{ $token }}">
                                    <td style="text-align: center;">{{ $loop->iteration }}.</td>
                                    <td style="text-align: center;">{{ $item->rKelompok->kode }}</td>
                                    <td>{{ $item->rKelompok->rBiodata->name }} <br> {{ $item->rKelompok->rBiodata->noidentitas }} <br> {{ $item->rKelompok->rBiodata->fakultas }} <br> {{ $item->rKelompok->rBiodata->prodi }}</td>
                                    <td style="text-align: center;">{{ $item->rJenis->nama }}</td>
                                    <td style="text-align: center;">{{ $item->judul }}</td>
                                    <td style="text-align: center;">
                                        @if(substr(number_format($item->usulan_dana, 2, ',', '.'), -3) === ',00')
                                            Rp{{ substr(number_format($item->usulan_dana, 2, ',', '.'), 0, -3) }},-
                                        @else
                                            Rp{{ number_format($item->usulan_dana, 2, ',', '.') }}
                                        @endif
                                    </td>
                                    <td style="text-align: center;">
                                        @if(is_null($item->rDaftarPro->status_final) || $item->rDaftarPro->status_final == 0)
                                            <span class="badge bg-info">Menunggu Reviewer</span>
                                        @elseif($item->rDaftarPro->status_final == 1)
                                            <span class="badge bg-success">Lolos Seleksi Internal</span>
                                        @else
                                            <span class="badge bg-danger">Tidak Lolos Seleksi Internal</span>
                                        @endif
                                    </td>
                                    <td style="text-align: center;">
                                        <a data-toggle="tooltip"  data-id="{{ $item->proposal_id }}" data-original-title="Lihat" class="btn btn-info btn-sm lihatDet"><i class="far fa-eye"></i> Lihat</a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->

    <div id="lihatDetail" class="modal fade">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="lihatLabel">Detail Proposal </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <div class="table-responsive">
                            <table class="table mb-0" id="tableDetail">
                                <tbody>

                                </tbody>

                            </table>
                        </div>
                    </p>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
<script src="{{ asset('theme/js/pages/datatables.init.js') }}"></script>

<script>
    $(function(){
        $('#input-file').change(function(){
            var input = this;
            var url = window.URL.createObjectURL(this.files[0]);
            $("#uploadRev iframe").attr("src", url);
        })
    })

    function hapus(id, rowId){
        Swal.fire({
            title: 'Apakah anda yakin untuk menghapus Kelompok?',
            text: "Semua anggota kelompok juga akan terhapus",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'OK',
        }).then((result) => {
            if (result.isConfirmed) {
                var token = '{{ csrf_token() }}';
                var request = $.ajax({
                    url: '{{ route('mahasiswa.proposal.hapus') }}',
                    type: 'POST',
                    dataType: 'html',
                    data: {id:id, _token:token},
                    success: function(data){
                        Swal.fire({
                            title: 'Data Berhasil Di Hapus',
                            icon: 'success',
                            showConfirmButton: false,
                            timer: 1500
                        });

                        $('#'+rowId).remove();
                    },
                    error: function(xhr, status, error){
                        Swal.fire({
                            position: 'top-end',
                            icon: 'error',
                            title: xhr.responseText,
                            showConfirmButton: false,
                            timer: 3500
                        });
                    }
                });
            }
        })
    }

    $(document).ready(function(){

        $('#datatable').on('click','.lihatDet',function(){
            var proId = $(this).attr('data-id');

        if(proId != null || proId != ''){
                // Empty modal data
                $('#tableDetail tbody').empty();

                $.ajax({
                    url: "{{route('dosen.seleksi-internal.lihat')}}",
                    data : {
                        "proposal_id": proId,
                    },
                    dataType: 'json',
                    success: function(response){
                        // Add user details
                        $('#tableDetail tbody').html(response.html);

                        // Display Modal
                        $('#lihatDetail').modal('show');
                    }
                });
            }
        });

    });
</script>
@endsection
