@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-12 col-md-8 col-sm-12">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Mahasiswa</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
            <div class="col-12 col-md-4 col-sm-12">
                <div class="float-end d-none d-md-block">
                    @if($cekKel == 0)
                        <a href="{{ route('mahasiswa.kelompok.create') }}" class="btn btn-primary waves-effect waves-light">Tambah</a>
                        {{-- <button type="button" class="btn btn-primary waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#tmbhKel">Tambah Data</button> --}}
                    @endif
                </div>
            </div>
            {{-- Untuk mobile --}}
            <div class="d-block d-md-none mt-4 mb-n3">
                @if($cekKel == 0)
                    <a href="{{ route('mahasiswa.kelompok.create') }}" class="btn btn-primary btn-sm waves-effect waves-light w-100">Tambah</a>
                @endif
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('mahasiswa.kelompok.index') }}">
                        <div class="row">
                            <div class="col-md-8"></div>
                            <div class="col-md-4 text-right">
                                <div class="row">
                                    <label class="col-sm-3 col-form-label"></label>
                                    <label class="col-sm-3 col-form-label">Tahun : </label>
                                    <div class="col-sm-6">
                                        <select class="form-select" name="year" onchange="this.form.submit()">
                                            @foreach($periode as $per)
                                            <option value="{{ $per->nama }}" {{ $year == $per->nama ? 'selected' : '' }}>{{ $per->nama }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    <br>
                    <div class="table-responsive">
                        <table id="datatable" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Kode Kelompok</th>
                                    <th>Ketua</th>
                                    <th>NIM</th>
                                    <th>Dosen Pembimbing</th>
                                    <th>NIDN</th>
                                    <th>Status</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($kelompok as $item)
                                @php $token = Str::random(30); @endphp
                                <tr id="row-{{ $token }}">
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $item->kode }}</td>
                                    <td>{{ $item->rAnggota->where('status_ketua', 1)->count() > 0 ? $item->rAnggota->where('status_ketua', 1)[0]->nama : '' }}</td>
                                    <td>{{ $item->rAnggota->where('status_ketua', 1)->count() > 0 ? $item->rAnggota->where('status_ketua', 1)[0]->nim : ''}}</td>
                                    <td>{{ $item->nama_dosen }}</td>
                                    <td>{{ $item->nidn_dosen }}</td>
                                    <td>
                                        @if(!is_null($item->kirim))
                                            @if($item->status == 0)
                                                <span class="badge bg-warning">Menunggu Persetujuan Dosen</span>
                                            @elseif($item->status == 2)
                                                <span class="badge bg-danger">Di Tolak Dosen</span>
                                            @else
                                                <span class="badge bg-success">Sudah Disetujui Dosen</span>
                                            @endif
                                        @endif
                                    </td>
                                    <td>
                                        <button data-bs-toggle="modal" data-bs-target="{{ '#lihat'.$item->kelompok_id }}" href="{{ URL::to('mahasiswa/kelompok-new', encrypt($item->kelompok_id)) }}" class="btn btn-info btn-sm">Lihat</button>
    
                                        @if((auth()->user()->id == $item->created_user) && ($item->status == 0))
                                            <a href="{{ URL::to('mahasiswa/kelompok-new', encrypt($item->kelompok_id)) }}" class="btn btn-warning btn-sm">Edit</a>
                                            <a onclick="hapus('{{ encrypt($item->kelompok_id) }}', 'row-{{ $token }}')" class="btn btn-danger btn-sm">Hapus</a>
                                        @endif
    
                                        <div id="{{ 'lihat'.$item->kelompok_id }}" class="modal fade" tabindex="-1" role="dialog"
                                            aria-labelledby="lihatLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-xl">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="lihatLabel">Data Kelompok </h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <p>
                                                            <div class="table-responsive">
                                                                <table class="table table-striped mb-0">
                                                                    <thead>
                                                                        <tr>
                                                                            <th>No</th>
                                                                            <th>Nama</th>
                                                                            <th>NIM</th>
                                                                            <th>Fakultas</th>
                                                                            <th>Program Studi</th>
                                                                            <th>Keterangan</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <tr>
                                                                        @foreach ($item->rAnggota as $value)
                                                                            <tr>
                                                                                <td>{{ $loop->iteration }}</td>
                                                                                <td>{{ ucwords(strtolower($value->nama)) }}</td>
                                                                                <td>{{ $value->nim }}</td>
                                                                                <td>{{ $value->fakultas }}</td>
                                                                                <td>{{ $value->prodi }}</td>
                                                                                <td>
                                                                                    @if($value->status_ketua == 1)
                                                                                        Ketua
                                                                                    @else
                                                                                        Anggota {{ $loop->iteration-1 }}
                                                                                    @endif
                                                                                </td>
                                                                            </tr>
                                                                        @endforeach
                                                                        </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>  
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->


@endsection

@section('js')


<script>
    $(document).ready(function() {

        // $(".selectmodal").select2({
        //     ajax: {
        //         url: "https://api.github.com/search/repositories",
        //         dataType: 'json',
        //         delay: 250,
        //         data: function (params) {
        //         return {
        //             q: params.term, // search term
        //             page: params.page
        //         };
        //         },
        //         processResults: function (data, params) {
        //         // parse the results into the format expected by Select2
        //         // since we are using custom formatting functions we do not need to
        //         // alter the remote JSON data, except to indicate that infinite
        //         // scrolling can be used
        //         params.page = params.page || 1;

        //         return {
        //             results: data.items,
        //             pagination: {
        //             more: (params.page * 30) < data.total_count
        //             }
        //         };
        //         },
        //         cache: true
        //     },
        //     placeholder: 'Search for a repository',
        //     minimumInputLength: 1,
        //     templateResult: formatRepo,
        //     templateSelection: formatRepoSelection
        //     });

        $("#selectmodal").select2({
            dropdownParent: $("#tmbhKel")
        });
    });

    function hapus(id, rowId){
        Swal.fire({
            title: 'Apakah anda yakin untuk menghapus Kelompok?',
            text: "Semua anggota kelompok juga akan terhapus",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'OK',
        }).then((result) => {
            if (result.isConfirmed) {
                var token = '{{ csrf_token() }}';
                var request = $.ajax({
                    url: '{{ route('mahasiswa.kelompok.hapus') }}',
                    type: 'POST',
                    dataType: 'html',
                    data: {id:id, _token:token},
                    success: function(data){
                        Swal.fire({
                            title: 'Data Berhasil Di Hapus',
                            icon: 'success',
                            showConfirmButton: false,
                            timer: 1500
                        });

                        $('#'+rowId).remove();
                    },
                    error: function(xhr, status, error){
                        Swal.fire({
                            position: 'top-end',
                            icon: 'error',
                            title: xhr.responseText,
                            showConfirmButton: false,
                            timer: 3500
                        });
                    }
                });
            }
        })
    }


</script>
@endsection
