@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Mahasiswa</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    <h4 class="card-title">Anggota Kelompok</h4>
                    <p class="card-title-desc"></p>

                    <div class="row mb-3">
                        <label for="kode" class="col-sm-2 col-form-label">NIM</label>
                        <div class="col-sm-4">
                            <div class="input-group">
                                <input class="form-control" type="text" id="nim" name="txCari" placeholder="NIM" onkeypress="return hanyaAngka(event)">
                                <span class="input-group-btn" id="btn-addon2">
                                    <button id="btnCari" class="btn btn-warning" onclick="carianggota();">
                                        <i class="fa fa-search"></i>
                                    </button>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div id="viewPersonil">
                        <div class="row mb-3">
                            <label for="nama" class="col-sm-2 col-form-label">Nama</label>
                            <div class="col-sm-10">
                                <span id="nama"> - </span>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label for="fakultas" class="col-sm-2 col-form-label">Fakultas</label>
                            <div class="col-sm-10">
                                <span id="fakultas"> - </span>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label for="prodi" class="col-sm-2 col-form-label">Program Studi</label>
                            <div class="col-sm-10">
                                <span id="prodi"> - </span>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
<meta name="csrf_token" content="{{ csrf_token() }}" />
@endsection

@section('js')
<script>
var urlPerson = "{{url('/selectmahasiswa')}}";
</script>
{{Html::script('js/person.js')}}
@endsection
