@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-lg-8 col-md-8 col-sm-12">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Mahasiswa</li>
                    <li class="breadcrumb-item"><a href="{{ url()->previous() }}">Monev Internal II</a></li></li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-12">
                <div class="float-end d-block d-md-block d-sm-block">
                    <button class="btn btn-primary waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#anggaran"><i class="fas fa-plus-circle me-2"></i> Tambah Data</button>
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datatable" class="table table-bordered nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead style="vertical-align: middle; text-align: center;">
                                <tr>
                                    <th colspan="10" style="font-size: 16px">
                                        Rencana Anggaran Biaya
                                        <br>
                                        <span style="font-style: italic; font-size: 14px; display: block; margin-top: 5px; text-align: left">
                                            Total Anggaran: Rp {{ isset($monev->rProposal->pendanaan) ? number_format($monev->rProposal->pendanaan, 2, ',', '.') : '0' }}
                                        </span>
                                    </th>
                                </tr>
                                <tr>
                                    <th>No.</th>
                                    <th>Nama Kegiatan</th>
                                    <th>Nama Barang</th>
                                    <th>Tanggal Pembelian</th>
                                    <th>Kuantitas</th>
                                    <th>Satuan Barang</th>
                                    <th>Harga Satuan<br>(Rp)</th>
                                    <th>Total Harga per Barang<br>(Rp)</th>
                                    <th>Bukti Nota</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $totalDana = 0;
                                    $sisaDana = 0;
                                @endphp
                                @foreach ($monev->rBuktiAnggaran as $item)
                                @php
                                    $token = Str::random(30);
                                    $totalDana += $item->total_harga_per;
                                @endphp
                                    <tr id="{{ $item->proposal_id }}">
                                        <td style="text-align: center;">{{ $loop->iteration }}.</td>
                                        <td>{{ $item->nama_kegiatan }}</td>
                                        <td>{{ $item->nama_barang }}</td>
                                        <td align="center">{{ $item->tgl_pembelian ? \Carbon\Carbon::make($item->tgl_pembelian)->translatedFormat('d F Y') : '-' }}</td>
                                        <td align="center">{{ $item->kuantitas }}</td>
                                        <td align="center">{{ $item->jenis_satuan }}</td>
                                        <td align="end">{{ $item->harga_satuan }}</td>
                                        <td align="end">{{ $item->total_harga_per }}</td>
                                        <td style="text-align: center;"><a href="https://statik.unesa.ac.id/simpmw/monev/II/bukti-anggaran/{{ $item->nota_file }}" target="_blank" title="Bukti Nota" class="btn btn-info btn-sm waves-effect waves-light"> <i class="fas fa-search"></i> Lihat</a></td>
                                        <td style="text-align: center;">
                                            <button class="btn btn-primary btn-sm fa fa-edit" data-toggle="tooltip" data-placement="top" title="Edit Data"></button>
                                            <a onclick="hapus('{{ encrypt($item->id) }}', 'row-{{ $token }}')" class="btn btn-danger btn-sm fa fa-trash-alt" data-toggle="tooltip" data-placement="top" title="Hapus Data"></a>
                                        </td>
                                    </tr>
                                @endforeach
                                @php
                                    $sisaDana = $monev->rProposal->pendanaan - $totalDana;
                                @endphp
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="7" style="text-align: right;"><strong>Total Anggaran yang Terpakai</strong></td>
                                    <td colspan="3">
                                        <div style="display: flex; justify-content: space-between;">
                                            <span>Rp</span>
                                            <span><strong>{{ number_format($totalDana, 2, ',', '.') }}</strong></span>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="7" style="text-align: right;"><strong>Sisa Anggaran</strong></td>
                                    <td colspan="3">
                                        <div style="display: flex; justify-content: space-between;">
                                            <span>Rp</span>
                                            <span><strong>{{ number_format($sisaDana, 2, ',', '.') }}</strong></span>
                                        </div>
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->

    <div id="anggaran" class="modal fade" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content">
                <form id="form-add" action="{{ route('mahasiswa.monev-anggaran-store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="myModalLabel">Tambah Data Bukti Penggunaan Anggaran</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" style="max-height: 70vh;">
                        {{-- <input class="form-control" type="hidden" name="proposal_id" id="proposal_id" value="{{ $proposal->proposal_id }}"> --}}
                        <input class="form-control" type="hidden" name="monev_id" id="monev_id" value="{{ $monev->id }}">
                        <input class="form-control" type="hidden" name="proposal_id" id="proposal_id" value="{{ $monev->proposal_id }}">
                        <div class="row mb-3">
                            <label for="nama_kegiatan" class="col-sm-4 col-form-label">Nama Kegiatan<span style="color: red;"> *</span></label>
                            <div class="col-sm-8 col-lg-8">
                                <input class="form-control" type="text" name="nama_kegiatan" id="nama_kegiatan" value="{{ old('nama_kegiatan') }}" placeholder="Masukkan nama kegiatan">
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label for="nama_barang" class="col-sm-4 col-form-label">Nama Barang<span style="color: red;"> *</span></label>
                            <div class="col-sm-8 col-lg-8">
                                <input class="form-control" type="text" name="nama_barang" id="nama_barang" value="{{ old('nama_barang') }}" placeholder="Masukkan nama barang">
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label for="tgl_pembelian" class="col-sm-4 col-form-label">Tanggal Pembelian<span style="color: red;"> *</span></label>
                            <div class="col-sm-8 col-lg-8">
                                <input class="form-control" type="date" name="tgl_pembelian" id="tgl_pembelian" value="{{ old('tgl_pembelian') }}" placeholder="Pilih tanggal pembelian barang">
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label for="kuantitas" class="col-sm-4 col-form-label">Kuantitas Barang<span style="color: red;"> *</span></label>
                            <div class="col-sm-8 col-lg-8">
                                <input class="form-control" type="text" inputmode="decimal" name="kuantitas" id="kuantitas" value="{{ old('kuantitas') }}" placeholder="Masukkan jumlah kuantitas" onkeypress="return isNumberOrDecimal(event)" oninput="validateDecimalInput(this)">
                                <small id="inputError" class="text-danger" style="display: none;">Inputan hanya berupa angka, satu titik (.) atau koma (,)</small>
                                <small id="decimalError" class="text-danger" style="display: none;">Titik (.) atau koma (,) tidak boleh lebih dari satu kali inputan</small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label for="jenis_satuan" class="col-sm-4 col-form-label">Jenis Satuan Barang<span style="color: red;"> *</span></label>
                            <div class="col-sm-8 col-lg-8">
                                <select class="form-select" aria-label="Default select example" name="jenis_satuan" id="jenis_satuan">
                                    <option value="">- Pilih -</option>
                                    @foreach($jenis_satuan as $satuan)
                                        <option value="{{ $satuan->jenis_satuan }}">{{ $satuan->jenis_satuan }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label for="harga_satuan" class="col-sm-4 col-form-label">Harga Satuan <span style="margin-left: 5px"><i class="mdi mdi-information-outline" data-bs-toggle="tooltip" title="Inputan hanya berupa angka, tanda titik (.) hanya untuk nominal desimal "></i></span><span style="color: red;"> *</span></label>
                            <div class="col-sm-8 col-lg-8">
                                <div class="input-group">
                                    <span class="input-group-text">Rp</span>
                                    <input class="form-control" type="text" id="harga_satuan" name="harga_satuan"  value="{{ old('harga_satuan') }}" placeholder="Masukkan harga satuan (cth: 950000 atau 950000.50)" required onkeypress="return isNumberKey(event)" onkeyup="formatRupiah(this)">
                                </div>
                                <small class="text-danger" style="display: block;">
                                    Tanda titik hanya (.) untuk bilangan desimal. Contoh: 950000 atau 950000.50
                                </small>
                                <small id="invalidInput" class="text-danger" style="display: none;">Harap masukkan angka atau desimal (contoh: 950000 atau 9500000.50)</small>
                                <small id="dotWarning" style="display: none; color: red;">Simbol titik (.) tidak boleh diinputkan lebih dari 1 | tanda (.) hanya untuk nominal desimal</small>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label for="nota_file" class="col-sm-4 col-form-label">Unggah File Nota/Kwitansi <span style="margin-left: 5px"><i class="mdi mdi-information-outline" data-bs-toggle="tooltip" title="Unggah file dalam bentuk PDF (maks. 5 MB)"></i></span><span style="color: red;"> *</span></label>
                            <div class="col-sm-6 col-lg-6">
                                <input type="file" name="nota_file" class="form-control" id="input-file" accept="application/pdf">
                                @if ($errors->has('file')) <span class="text-danger"><i>{{ $errors->first('file') }}</i></span> @endif
                                {{-- <iframe id="view-pdf" width="80%" height="80%" frameborder="0" src="{{ $proposal ? 'https://statik.unesa.ac.id/simpkm/proposal/'.$proposal->rPeriode->nama.'/'.$proposal->upload_dokumen : '' }} "></iframe> --}}
                            </div>
                            <div class="col-sm-2 col-lg-2">
                                <button type="button" class="form-control btn btn-warning" id="btnPreview">Preview</button>
                            </div>
                        </div>
                        <div id="previewContent" class="mfp-hide">
                            <h3>Preview File Nota/Kwitansi</h3>
                            <iframe id="view-pdf" width="80%" height="80%" frameborder="0" src=""></iframe>
                        </div>                        
                            {{-- <div class="col-12">
                                <h5 class="font-size-16">Keterangan : </h5>
                            <p>
                                <textarea id="textarea" class="form-control" maxlength="225" rows="3" name="keterangan_luaran" ></textarea>
                            </p>
                            </div> --}}
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary waves-effect" data-bs-dismiss="modal">Tutup</button>
                    <button type="reset" class="btn btn-danger waves-effect">Reset</button>
                    <button type="submit" class="btn btn-primary waves-effect waves-light">Simpan</button>
                </div>
                </form>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
@endsection

@section('js')
<script>
    $(document).ready(function() {
        const table = $('#datatable').DataTable({
            autoWidth: false,
            order: [[0, 'asc']],
            columnDefs: [
                {
                    targets: [0], 
                    visible: true,
                    searchable: true
                }
            ]
        });

        function handleServerResponse(response) {
            if(response.status === 'success') {
                Swal.fire({
                    icon: 'success',
                    title: 'Berhasil',
                    text: response.message || 'Data berhasil disimpan',
                    confirmButtonText: 'OK'
                }).then(() => {
                    location.reload();
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Gagal',
                    text: response.message || 'Terjadi kesalahan dalam operasi',
                    confirmButtonText: 'Tutup'
                });
            }
        }
    });
</script>
<script>
    $(document).ready(function () {
        const modalAnggaran = $('#anggaran');

        $('#btnPreview').on('click', function () {
            const fileInput = document.getElementById('input-file');
            const file = fileInput.files[0];

            if (file && file.type === 'application/pdf') {
                const fileURL = URL.createObjectURL(file);

                $('#view-pdf').attr('src', fileURL);

                modalAnggaran.modal('hide');

                $.magnificPopup.open({
                    items: {
                        src: '#previewContent',
                        type: 'inline'
                    },
                    callbacks: {
                        close: function () {
                            modalAnggaran.modal('show');
                        }
                    }
                });
            } else {
                alert('Harap unggah file PDF untuk pratinjau.');
            }
        });
    });
</script>
<script>
    // function hapus(id, rowId){
    //     Swal.fire({
    //         title: 'Apakah Anda yakin untuk menghapus usulan ini?',
    //         text: "File yang sudah terupload juga akan terhapus",
    //         icon: 'warning',
    //         showCancelButton: true,
    //         confirmButtonText: 'OK',
    //     }).then((result) => {
    //         if (result.isConfirmed) {
    //             var token = '{{ csrf_token() }}';
    //             console.log("Data yang dikirim:", {id: id, _token: token});
    //             $.ajax({
    //                 url: '{{ route('mahasiswa.anggaran.hapus') }}',
    //                 type: 'POST',
    //                 dataType: 'html',
    //                 data: {id:id, _token:token},
    //                 success: function(data){
    //                     Swal.fire({
    //                         title: 'Data Berhasil Di Hapus',
    //                         icon: 'success',
    //                         showConfirmButton: false,
    //                         timer: 1500
    //                     });

    //                     $('#'+rowId).remove();
    //                 },
    //                 error: function(xhr, status, error){
    //                     Swal.fire({
    //                         position: 'top-end',
    //                         icon: 'error',
    //                         title: xhr.responseText,
    //                         showConfirmButton: false,
    //                         timer: 3500
    //                     });
    //                 }
    //             });
    //         }
    //     })
    // }
    function hapus(id, rowId) {
        Swal.fire({
            title: 'Konfirmasi',
            text: 'Apakah Anda yakin ingin menghapus data ini?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Ya, hapus!',
            cancelButtonText: 'Batal',
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '{{ route('mahasiswa.anggaran.hapus') }}', // Pastikan route benar
                    type: 'POST',
                    data: {
                        id: id, // Kirimkan id dari BuktiAnggaran
                        _token: '{{ csrf_token() }}',
                    },
                    success: function(response) {
                        if (response.status === 'success') {
                            Swal.fire('Berhasil!', response.message, 'success').then(() => {
                                location.reload(); // Reload halaman setelah berhasil
                            });
                        } else {
                            Swal.fire('Gagal!', response.message, 'error');
                        }
                    },
                    error: function(xhr) {
                        Swal.fire('Error!', 'Terjadi kesalahan saat menghapus data.', 'error');
                    },
                });
            }
        });
    }

    function isNumberOrDecimal(evt) {
        var charCode = (evt.which) ? evt.which : event.keyCode;

        // Allow numbers (0-9), dot (.), and comma (,)
        if ((charCode >= 48 && charCode <= 57) || charCode === 44 || charCode === 46) {
            return true;
        }
        
        // Prevent alphabetic characters and show error
        evt.preventDefault();
        document.getElementById('inputError').style.display = 'block';
        return false;
    }

    function validateDecimalInput(el) {
        var value = el.value;
        var dotCount = (value.match(/\./g) || []).length;
        var commaCount = (value.match(/,/g) || []).length;

        // Hide the input error message
        document.getElementById('inputError').style.display = 'none';

        // If the input starts with a dot or comma, replace with '0' or '0.'
        if (value.startsWith('.') || value.startsWith(',')) {
            el.value = '0' + value;
            value = el.value;
        }

        // Prevent more than one dot or comma
        if (dotCount > 1) {
            el.value = value.substring(0, value.lastIndexOf('.'));
            document.getElementById('decimalError').style.display = 'block';
        } else if (commaCount > 1) {
            el.value = value.substring(0, value.lastIndexOf(','));
            document.getElementById('decimalError').style.display = 'block';
        } else {
            document.getElementById('decimalError').style.display = 'none';
        }

        // Prevent both dot and comma being used together
        if (dotCount > 0 && commaCount > 0) {
            el.value = value.substring(0, value.length - 1);
            document.getElementById('decimalError').style.display = 'block';
        }
    }
</script>
<script>
    var rpAdded = false; // Flag untuk menandai apakah 'Rp' sudah ditambahkan
    var dotCount = 0; // Menghitung jumlah titik (.) yang sudah dimasukkan

    function isNumberKey(evt) {
        var charCode = (evt.which) ? evt.which : event.keyCode;

        // Cek apakah karakter yang dimasukkan adalah angka atau titik (.) dan batasi jumlah titik menjadi 1
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57)) {
            document.getElementById('invalidInput').style.display = 'block';
            document.getElementById('dotWarning').style.display = 'none'; // Sembunyikan peringatan titik (.) berlebihan
            return false;
        }

        document.getElementById('invalidInput').style.display = 'none';
        return true;
    }

    function formatRupiah(el) {
        var val = el.value.trim();

        // Jika input kosong, reset flag 'rpAdded' dan hitungan titik
        if (val === '') {
            rpAdded = false;
            dotCount = 0;
            return;
        }

        // Tambahkan 'Rp0.' jika input diawali dengan titik (.) dan 'Rp' belum ditambahkan sebelumnya
        if (val.startsWith('.') && !rpAdded) {
            val = '0.';
            rpAdded = true; // Set flag 'rpAdded' menjadi true
            dotCount = 1; // Tambahkan satu titik
        } else if (!rpAdded) {
            // Tambahkan 'Rp' jika 'Rp' belum ditambahkan sebelumnya
            val;
            rpAdded = true; // Set flag 'rpAdded' menjadi true
        }

        // Hitung jumlah titik (.) dalam input
        dotCount = (val.match(/\./g) || []).length;

        // Tampilkan peringatan jika terdapat lebih dari satu titik (.) dan sembunyikan peringatan input tidak valid
        if (dotCount > 1) {
            document.getElementById('dotWarning').style.display = 'block';
            document.getElementById('invalidInput').style.display = 'none'; // Sembunyikan peringatan input tidak valid
            var secondDotIndex = val.indexOf('.', val.indexOf('.') + 1);
            val = val.slice(0, secondDotIndex) + val.slice(secondDotIndex + 1); // Hapus titik (.) yang berlebihan dari input
            dotCount = 1; // Set jumlah titik kembali menjadi 1
        } else {
            document.getElementById('dotWarning').style.display = 'none'; // Sembunyikan peringatan titik (.) berlebihan
        }

        el.value = val;
    }
</script>
@endsection
