@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Mahasiswa</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
            <div class="col-md-4">
                <div class="float-end d-none d-md-block">

                </div>
            </div>
        </div>

    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('mahasiswa.seleksi-belmawa') }}">
                        <div class="row">
                            <div class="col-md-8"></div>
                            <div class="col-md-4 text-right">
                                <div class="row">
                                    <label class="col-sm-3 col-form-label"></label>
                                    <label class="col-sm-3 col-form-label">Tahun : </label>
                                    <div class="col-sm-6">
                                        <select class="form-select" name="year" onchange="this.form.submit()">
                                        @foreach($periode as $per)
                                            <option value="{{ $per->nama }}" {{ $year == $per->nama ? 'selected' : '' }}>{{ $per->nama }}</option>
                                        @endforeach
                                    </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    <br>
                    <table id="datatable" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                        <thead>
                        <tr>
                            <th>No</th>
                            <th>Kode Kelompok</th>
                            <th>Identitas Ketua</th>
                            <th>Identitas Dosen Pembimbing</th>
                            <th>Kategori PMW</th>
                            <th>Judul Proposal</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                        </thead>
                        <tbody>
                            @foreach ($proposal as $item)
                            @php $token = Str::random(30); @endphp
                            <tr id="row-{{ $token }}">
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $item->rKelompok->kode }}</td>
                                <td>{{ $item->rKelompok->rBiodata->name }} <br> {{ $item->rKelompok->rBiodata->noidentitas }} <br> {{ $item->rKelompok->rBiodata->fakultas }} <br> {{ $item->rKelompok->rBiodata->prodi }}</td>
                                <td>{{ $item->rKelompok->nama_dosen }} <br> {{ $item->rKelompok->nidn_dosen }}</td>
                                <td>{{ $item->rJenis->nama }}</td>
                                <td>{{ $item->judul }}</td>
                                <td>
                                    @if($item->rBelmawa)
                                        @if($item->rBelmawa->status == '0')
                                            <span class="badge bg-warning">Upload Proposal Belmawa</span>
                                        @else
                                            <span class="badge bg-danger">Tidak Lolos Seleksi Belmawa</span>
                                        @endif
                                    @endif
                                </td>
                                <td>
                                    @if($item->rBelmawa)
                                        @if(is_null($item->rBelmawa->upload_dokumen))
                                            <a href="{{ URL::to('mahasiswa/seleksi-belmawa/revisi', $item->proposal_id) }}" type="button" class="btn btn-warning btn-sm waves-effect waves-light"> <i class="fas fa-edit"></i> Edit</a>
                                        @else
                                            <button data-bs-toggle="modal" data-bs-target="{{ '#lihat'.$item->proposal_id }}" href="{{ URL::to('mahasiswa/kelompok-new', encrypt($item->proposal_id)) }}" class="btn btn-info btn-sm">Lihat</button>
                                            {{-- <a onclick="hapus('{{ encrypt($item->proposal_id) }}', 'row-{{ $token }}')" class="btn btn-danger btn-sm">Hapus</a> --}}
                                        @endif
                                    @endif

                                    <div id="{{ 'lihat'.$item->proposal_id }}" class="modal fade" tabindex="-1" role="dialog"
                                        aria-labelledby="lihatLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-xl">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="lihatLabel">Detail Proposal Seleksi Belmawa</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <p>
                                                        <div class="table-responsive">
                                                            <table class="table mb-0">
                                                                <tr>
                                                                    <th>Judul Proposal</th>
                                                                    <td>{{ $item->judul }}</td>
                                                                </tr>
                                                                <tr>
                                                                    <th>Kategori PMW</th>
                                                                    <td>{{ $item->rJenis->nama }}</td>
                                                                </tr>
                                                                <tr>
                                                                    <th>Status</th>
                                                                    <td>
                                                                        @if($item->rBelmawa)
                                                                            @if($item->rBelmawa->status == '0')
                                                                                <span class="badge bg-success">Upload Proposal Belmawa</span>
                                                                            @else
                                                                                <span class="badge bg-danger">Tidak Lolos Seleksi Belmawa</span>
                                                                            @endif
                                                                        @endif
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <th>Proposal</th>
                                                                    <td>
                                                                        <a href="https://statik.unesa.ac.id/simpmw/proposal/revisi/{{ $item->rPeriode->nama }}/{{ $item->rBelmawa->upload_dokumen }}"  target="_blank" class="btn btn-success btn-sm"> <i class="far fa-eye"></i> Lihat Proposal</a>
                                                                        <iframe id="view-pdf" width="100%" height="400px" src="https://statik.unesa.ac.id/simpmw/proposal/revisi/{{ $item->rPeriode->nama }}/{{ $item->rBelmawa->upload_dokumen }}" frameborder="0"></iframe>

                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <th>Komentar</th>
                                                                    <td> </td>
                                                                </tr>
                                                            </table>
                                                        </div>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>



                                </div>

                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>

                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->

@endsection

@section('js')
<script>

    $(function(){
        $('#input-file').change(function(){
            var input = this;
            var url = window.URL.createObjectURL(this.files[0]);
            $("#uploadRev iframe").attr("src", url);
        })
    })

    function hapus(id, rowId){
        Swal.fire({
            title: 'Apakah anda yakin untuk menghapus usulan ini?',
            text: "file yang sudah terupload juga terhapus",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'OK',
        }).then((result) => {
            if (result.isConfirmed) {
                var token = '{{ csrf_token() }}';
                var request = $.ajax({
                    url: '{{ route('mahasiswa.proposal.hapus') }}',
                    type: 'POST',
                    dataType: 'html',
                    data: {id:id, _token:token},
                    success: function(data){
                        Swal.fire({
                            title: 'Data Berhasil Di Hapus',
                            icon: 'success',
                            showConfirmButton: false,
                            timer: 1500
                        });

                        $('#'+rowId).remove();
                    },
                    error: function(xhr, status, error){
                        Swal.fire({
                            position: 'top-end',
                            icon: 'error',
                            title: xhr.responseText,
                            showConfirmButton: false,
                            timer: 3500
                        });
                    }
                });
            }
        })
    }
</script>
@endsection
