@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection
@php
    $jenis = $data['jenis']['0'];
    $encrypted_id = $data['encrypted_id'];
    $jenis_penilaian_monev = $data['jenis_penilaian_monev'];
@endphp

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Setting</li>
                    <li class="breadcrumb-item"><a href="{{ URL::to('operator/jenis-penilaian-monev') }}">Penilaian Monev Internal</a></li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    {!! Form::model($jenis, ['route' => ['operator.jenis-penilaian-monev.update', $encrypted_id], 'method'=>'patch', 'class'=>'form-horizontal']) !!}
                    {!! csrf_field() !!}
                        <div class="row mb-3">
                            <label for="example-text-input" class="col-sm-2 col-form-label">Kategori PMW </label>
                            <div class="col-sm-10">
                                <label for="example-text-input" class="col-sm-2 col-form-label">: {{ $jenis->nama }}</label>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <label for="example-text-input" class="col-sm-2 col-form-label">Komponen Penilaian </label>
                            <div class="col-sm-10">
                                <label for="example-text-input" class="col-sm-2 col-form-label">: </label>
                                <div class="float-end d-none d-md-block">
                                    <a href="javascript:void(0)" onclick="createRow()" type="button" class="btn btn-warning waves-effect waves-light btn-sm"> <i class="fas fa-plus-circle"></i> Tambah Komponen</a>
                                </div>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-hover table-centered table-nowrap mb-0" id="tbData">
                                <thead>
                                    <tr>
                                        <th scope="col" width="75%">Komponen</th>
                                        <th scope="col" width="15%">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if(count($jenis_penilaian_monev) > 0)
                                        @foreach ($jenis_penilaian_monev as $key => $val)
                                            <tr>
                                                <td>
                                                    <input type="hidden" class="form-control" name="jenis_penilaian_monev_id[]" required value="{{ encrypt($val->jenis_penilaian_monev_id) }}">
                                                    <input type="text" class="form-control" name="nama[]" required value="{{ $val->nama }}">
                                                </td>
                                                <td>
                                                    <a onclick="$(this).parent().parent().remove();" class="btn btn-danger btn-sm btn-delete">Delete</a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr>
                                            <td>
                                                <input type="text" class="form-control" name="nama[]" required>
                                            </td>
                                            <td>
                                                <a onclick="$(this).parent().parent().remove();" class="btn btn-danger btn-sm btn-delete">Delete</a>
                                            </td>
                                        </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>

                        <div class="mt-3">
                            <div>
                                <button type="submit" class="btn btn-primary waves-effect waves-light me-1" style="display: none" id="btnSubmit">
                                    Submit
                                </button>
                                <a href="javascript:void(0)" class="btn btn-primary" onclick="submitForm()">Submit</a>
                                <button type="reset" class="btn btn-secondary waves-effect">
                                    Cancel
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
@endsection

@section('js')
<script>
    $(document).ready(function()
    {
        hitung();

        $(".input-mask").inputmask('integer',{min:1, max:100});

        $(".input-mask").maxlength({
            alwaysShow: !0,
            warningClass: "badge bg-success",
            limitReachedClass: "badge bg-danger",
            separator: " / ",
            validate: !0
        });
    });

    $(document).on("keyup", ".reqBobot", function() {
        hitung();
    });

    $(document).on('click','.btn-delete', function(){
        hitung();
    });

    function createRow()
    {
        $(function () {
            $.get("{{URL::to('operator/rowJenisPenilaianMonev')}}", function (data) {
                $("#tbData").append(data);
            });
        });
    }

    function submitForm()
    {
        $('#btnSubmit').click();
    }
</script>
@endsection
