@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
            <div class="col-md-4">
                <div class="float-end d-none d-md-block">

                </div>
            </div>
        </div>

    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datatable" class="table table-bordered dt-responsive wrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead>
                                <tr>
                                    <th>No.</th>
                                    <th>Nama</th>
                                    <th>Email</th>
                                    <th>Roles</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($users as $item)
                                @php
                                    $userToken = Str::random(30);
                                @endphp
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>
                                            {{ $item->name }} <br>
                                            {{ $item->rBiodata->noidentitas }}
                                        </td>
                                        <td>
                                            {{ $item->email }}
                                        </td>
                                        <td>
                                            @foreach ($item->rolesCustom as $role)
                                            <div id="{{ $userToken }}">
                                                <div class="row mb-2">
                                                    <div class="col-md-4">
                                                        {{ $role->name }}
                                                    </div>
                                                    <div class="col-md-6">
                                                        <button type="button" onclick="removeRole('{{ encrypt($item->id) }}', '{{ encrypt($role->id) }}', this)"  style="padding: 8px" class="btn btn-sm btn-danger"><i class="fa fa-times"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                            @endforeach
                                            <div class="row">
                                                <div class="col-md-7">
                                                    <div class="input-group mb-3">
                                                        <select class="form-select" name="" id="select_{{ $userToken }}">
                                                            @foreach ($roles as $role)
                                                                <option value="{{ encrypt($role->id) }}">{{ $role->name }}</option>
                                                            @endforeach
                                                        </select>
                                                        <div class="input-group-append">
                                                            <button style="padding: 8px" onclick="addRole('{{ $userToken }}', '{{ encrypt($item->id) }}')" class="btn btn-sm btn-success" type="button">Tambah</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
@endsection

@section('js')
<script src="{{ asset('theme/js/pages/datatables.init.js') }}"></script>
<script>
    $("body").on("click", ".delete", function (e) {
                e.preventDefault();
                var id = $(this).data('id');

                Swal.fire({
                    title: "Apakah Anda Yakin?",
                    text: "Anda akan menghapus data ini!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "Yes",
                    cancelButtonText: "No"
                }).then((result) => {
                    if (result.value) {
                        Swal.close();
                        $("#"+id).submit();
                    } else if (result.dismiss === Swal.DismissReason.cancel) {
                        Swal.fire('Dibatalkan', 'Data batal dihapus', 'error');
                    }
                });
            });

    function removeRole(user_id, role_id, element){
        var token = "{{ csrf_token() }}";
        var request = $.ajax({
            url:"{{ route('operator.remove-role') }}",
            type:"POST",
            dataType:"html",
            data:{
                user_id:user_id,
                role_id:role_id,
                _token:token
            },
            success: function(result){
                $(element).parent().parent().remove();
            }
        })
    }

    function addRole(user_token, user_id){
        var token = "{{ csrf_token() }}";
        var role_id = $('#select_'+user_token).val();
        var request = $.ajax({
            url:"{{ route('operator.add-role') }}",
            type:"POST",
            dataType:"html",
            data:{
                user_id:user_id,
                role_id:role_id,
                _token:token
            },
            success: function(result){
                $('#'+user_token).append(result);
            }
        })
    }

</script>
@endsection
