@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Monev Internal</li>
                    <li class="breadcrumb-item">Daftar {{ $title }}</li>
                    <li class="breadcrumb-item">Penilaian {{ $title }}</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    {{ Form::open(['url' => route('reviewer.monev-internal.store'), 'method' => 'post', 'id' => 'proposal', 'files' => 'true', 'enctype'=>'multipart/form-data']) }}
                    @csrf
                    <h4 class="card-title">{!! $title !!}</h4>
                    <p class="card-title-desc"></p>
                    <div class="row mb-3">
                        <label for="kode" class="col-sm-2 col-form-label">Judul</label>
                        <div class="col-sm-10">
                            <span>{{ $monev ? $monev->judul : '' }}</span>
                        </div>
                    </div>
                    <div class=" row mb-3">
                        <label class="col-sm-2 col-form-label">Kategori PMW</label>
                        <div class="col-sm-10">
                            <span>{{ $monev ? $monev->jenis_pkm : '' }}</span>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="kode" class="col-sm-2 col-form-label">Komponen Penilaian : </label>
                        <div class="col-sm-10 table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr style="text-align: center">
                                        <th>Komponen</th>
                                        {{-- <th style="width: 10%">Bobot</th> --}}
                                        <th style="width: 10%">Nilai</th>
                                        {{-- <th style="width: 10%">Nilai</th> --}}
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $total = 0;
                                    @endphp
                                    @foreach ($komponen as $res => $val)
                                        @php
                                            if(count($detil) == 0)
                                                $skor = '1';
                                            else
                                                $skor = $detil[$val->jenis_penilaian_monev_id]?:'1';

                                            $nilai = $skor*$val->bobot?:$val->bobot;
                                        @endphp
                                        <tr class="table-light">
                                            <td>
                                                <input type="hidden" name="jenis_penilaian_id[]" value="{{ $val->jenis_penilaian_monev_id }}">
                                                <span>{{ $val->nama }}</span>
                                            </td>
                                            {{-- <td><span id="varBobot-{{ $val->jenis_penilaian_monev_id }}">{{ $val->bobot }}</span></td> --}}
                                            <td>
                                                <select name="skor[]" class="hitung_skor" data-id="{{ $val->jenis_penilaian_monev_id }}">
                                                    <option value="1" @if($skor == '1') selected="selected" @endif>1</option>
                                                    <option value="2" @if($skor == '2') selected="selected" @endif>2</option>
                                                    <option value="3" @if($skor == '3') selected="selected" @endif>3</option>
                                                    <option value="5" @if($skor == '5') selected="selected" @endif>5</option>
                                                    <option value="6" @if($skor == '6') selected="selected" @endif>6</option>
                                                </select>
                                            </td>
                                            {{-- <td><span id='varNilai-{{ $val->jenis_penilaian_monev_id }}' class="clsNilai">{{ $nilai }}</span></td> --}}
                                        </tr>
                                        @php
                                            $total += $nilai;
                                        @endphp
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="3"><b>TOTAL NILAI</b></td>
                                        <td><span id='varTotalNilai'><b>{{ $total }}</b></span></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="kode" class="col-sm-2 col-form-label">Komentar Reviewer : </label>
                        <div class="col-sm-10">
                            <textarea name="komentar" class="form-control" rows="3">{{ $reviewer_monev->komentar?:'' }}</textarea>
                        </div>
                    </div>
                    <div class="mb-0">
                        <div>
                            <input name="reviewer_monev_id" type="hidden" value="{{ $reviewer_monev->reviewer_monev_id?:'' }}">
                            <input name="jenis_monev_id" type="hidden" value="{{ $monev->jenis_monev_id?:'' }}">
                            <button type="submit" class="btn btn-primary waves-effect waves-light me-1"> Submit </button>
                            <button type="reset" class="btn btn-secondary waves-effect"> Reset </button>
                            <a href="javascript:history.back()" class="btn btn-danger waves-effect"> Cancel </a>
                        </div>
                    </div>
                {{ Form::close() }}
                <br>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
@endsection

@section('js')
<script>
    $(function(){
        $('#input-file').change(function(){
            var input = this;
            var url = window.URL.createObjectURL(this.files[0]);
            $('#view-pdf').attr('src',url);
            $('#view-pdf').attr('height','500px');
        });

        $('.hitung_skor').on('change', function() {
            var id = $(this).attr("data-id");
            var val = $(this).find(":checked").val();
            var bobot = $('#varBobot-'+id).text();
            var nilai = val * bobot;
            $('#varNilai-'+id).text(nilai);

            sum();
        });
    });

    function sum(){
        var sum = 0;
        $('.hitung_skor').each(function () {
            sum += Number($(this).val());
        });

        $('#varTotalNilai').text(sum);
    }
</script>
@endsection
